/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.xmlvm.refcount.InstructionProcessor;
import org.xmlvm.refcount.RegisterSet;

public class InstructionUseInfo {
    Element Instruction;
    public Element putRelease = null;
    public List<String> possibleWrites = new ArrayList<String>();
    public RegisterSet willFree = RegisterSet.none();
    public RegisterSet willNull = RegisterSet.none();
    public RegisterSet requiresRetain = RegisterSet.none();
    public boolean freeTmpAfter;
    public boolean isWrite;
    public HashMap<Attribute, Boolean> typeIsObj = new HashMap();

    public InstructionUseInfo(Element element) throws DataConversionException {
        this.Instruction = element;
        this.checkUsage(element.getAttribute("vx"), element.getAttribute("vx-type"));
        this.checkUsage(element.getAttribute("vy"), element.getAttribute("vy-type"));
        this.checkUsage(element.getAttribute("vz"), element.getAttribute("vz-type"));
        this.checkUsage(element.getAttribute("register"), element.getAttribute("type"));
        this.checkUsage(element.getAttribute("register"), element.getAttribute("class-type"));
        this.possibleWrites.add("vx");
    }

    public void checkUsage(Attribute vy, Attribute vyType) throws DataConversionException {
        InstructionUseInfo use = this;
        if (vy != null && vyType != null) {
            if (InstructionProcessor.nonObjTypes.matcher(vyType.getValue()).matches()) {
                use.typeIsObj.put(vy, Boolean.FALSE);
            } else {
                use.typeIsObj.put(vy, Boolean.TRUE);
            }
        }
    }

    public RegisterSet writesObj() throws DataConversionException {
        if (this.isWrite) {
            for (Attribute key : this.typeIsObj.keySet()) {
                for (String s : this.possibleWrites) {
                    if (!key.getName().equals(s) || !this.typeIsObj.get(key).booleanValue()) continue;
                    return RegisterSet.from(key.getIntValue());
                }
            }
        }
        return RegisterSet.none();
    }

    public RegisterSet writesNonObj() throws DataConversionException {
        if (this.isWrite) {
            for (Attribute key : this.typeIsObj.keySet()) {
                for (String s : this.possibleWrites) {
                    if (!key.getName().equals(s) || this.typeIsObj.get(key).booleanValue()) continue;
                    return RegisterSet.from(key.getIntValue());
                }
            }
        }
        return RegisterSet.none();
    }

    public RegisterSet usesAsObj() throws DataConversionException {
        RegisterSet toRet = RegisterSet.none();
        if (this.isWrite) {
            for (Map.Entry<Attribute, Boolean> a : this.typeIsObj.entrySet()) {
                if (this.possibleWrites.contains(a.getKey().getName()) || !a.getValue().booleanValue()) continue;
                toRet.add(a.getKey().getIntValue());
            }
        } else {
            for (Map.Entry<Attribute, Boolean> a : this.typeIsObj.entrySet()) {
                if (!a.getValue().booleanValue()) continue;
                toRet.add(a.getKey().getIntValue());
            }
        }
        return toRet;
    }

    public RegisterSet usesAsNonObj() throws DataConversionException {
        RegisterSet toRet = RegisterSet.none();
        if (this.isWrite) {
            for (Map.Entry<Attribute, Boolean> a : this.typeIsObj.entrySet()) {
                if (this.possibleWrites.contains(a.getKey().getName()) || a.getValue().booleanValue()) continue;
                toRet.add(a.getKey().getIntValue());
            }
        } else {
            for (Map.Entry<Attribute, Boolean> a : this.typeIsObj.entrySet()) {
                if (a.getValue().booleanValue()) continue;
                toRet.add(a.getKey().getIntValue());
            }
        }
        return toRet;
    }

    public RegisterSet usedReg() throws DataConversionException {
        return this.usesAsNonObj().or(this.usesAsObj());
    }

    public RegisterSet allWrites() throws DataConversionException {
        return this.writesObj().or(this.writesNonObj());
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder();
        try {
            toRet.append(this.Instruction.getName());
            if (this.isWrite) {
                if (!this.writesNonObj().isEmpty()) {
                    toRet.append(" Wi:" + this.writesNonObj());
                } else {
                    toRet.append(" Wo:" + this.writesObj());
                }
            }
            if (!this.usesAsNonObj().isEmpty()) {
                toRet.append(" Ri:" + this.usesAsNonObj());
            }
            if (!this.usesAsObj().isEmpty()) {
                toRet.append(" Ro:" + this.usesAsObj());
            }
        }
        catch (DataConversionException ex) {
            toRet.append(ex.getMessage());
        }
        return toRet.toString();
    }
}

