/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.refcount;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xmlvm.refcount.CodePath;
import org.xmlvm.refcount.InstructionActions;
import org.xmlvm.refcount.InstructionProcessor;
import org.xmlvm.refcount.InstructionUseInfo;
import org.xmlvm.refcount.OnePathInstructionRegisterContents;
import org.xmlvm.refcount.ReferenceCountingException;
import org.xmlvm.refcount.RegisterSet;
import org.xmlvm.refcount.optimizations.DeferredNullingOptimization;
import org.xmlvm.refcount.optimizations.RefCountOptimization;
import org.xmlvm.refcount.optimizations.RegisterSizeAndNullingOptimization;

public class ReferenceCounting {
    Namespace dex = InstructionProcessor.dex;
    Namespace vm = InstructionProcessor.vm;
    String tmpRegNameSuffix = "tmp";
    Map<Integer, Element> labels = new HashMap<Integer, Element>();
    Map<Element, Element> nextElement = new HashMap<Element, Element>();
    Map<Element, Element> prevElement = new HashMap<Element, Element>();
    RunState curRun;

    public void process(Element method) throws DataConversionException, ReferenceCountingException {
        Attribute isAbstract = method.getAttribute("isAbstract");
        Attribute isNative = method.getAttribute("isNative");
        if (isAbstract != null && isAbstract.getBooleanValue()) {
            return;
        }
        if (isNative != null && isNative.getBooleanValue()) {
            return;
        }
        Element codeElement = method.getChild("code", this.dex);
        int numReg = codeElement.getAttribute("register-size").getIntValue();
        this.processRecStart(numReg, codeElement.getChildren(), codeElement);
    }

    private void setWillFree(Map<Element, InstructionActions> beenTo) throws ReferenceCountingException, DataConversionException {
        for (Map.Entry<Element, InstructionActions> e : beenTo.entrySet()) {
            RegisterSet objectRegs = e.getValue().getObjectRegs();
            if (!e.getValue().getConflict().isEmpty()) {
                throw new ReferenceCountingException("Ambigious register contents possible: Conflict: " + e.getValue().getConflict());
            }
            InstructionUseInfo useInfo = e.getValue().useInfo;
            RegisterSet toFree = e.getKey().getName().startsWith("return") ? objectRegs.andNot(useInfo.usedReg()) : objectRegs.and(useInfo.allWrites());
            useInfo.willFree = toFree;
            useInfo.willNull = toFree.clone();
        }
    }

    private boolean processReleaseRetain(Map<Element, InstructionActions> beenTo) throws ReferenceCountingException, DataConversionException {
        boolean needsTmpReg = false;
        for (Map.Entry<Element, InstructionActions> e : beenTo.entrySet()) {
            if (!e.getValue().getConflict().isEmpty()) {
                throw new ReferenceCountingException("Ambigious register contents possible: Conflict: " + e.getValue().getConflict());
            }
            InstructionUseInfo useInfo = e.getValue().useInfo;
            ArrayList<Element> toAddBefore = new ArrayList<Element>();
            ArrayList<Element> toAddAfter = new ArrayList<Element>();
            ArrayList<Element> toReleaseLast = new ArrayList<Element>();
            RegisterSet toFree = useInfo.willFree;
            for (int oneReg : toFree) {
                if (!useInfo.usesAsObj().and(useInfo.allWrites()).isEmpty()) {
                    if (useInfo.freeTmpAfter) {
                        throw new ReferenceCountingException("Conflict, tmp register used twice.");
                    }
                    Element tmpR = new Element("tmp-equals-r", this.vm);
                    tmpR.setAttribute("reg", oneReg + "");
                    toAddBefore.add(tmpR);
                    needsTmpReg = true;
                    Element releaseTmp = new Element("reg-release", this.vm);
                    releaseTmp.setAttribute("reg", this.tmpRegNameSuffix);
                    toReleaseLast.add(releaseTmp);
                    Element nullTmp = new Element("set-null", this.vm);
                    nullTmp.setAttribute("num", this.tmpRegNameSuffix);
                    toReleaseLast.add(nullTmp);
                    continue;
                }
                Element release = new Element("reg-release", this.vm);
                release.setAttribute("reg", oneReg + "");
                toAddBefore.add(release);
                if (!useInfo.willNull.has(oneReg)) continue;
                Element nullTmp = new Element("set-null", this.vm);
                nullTmp.setAttribute("num", oneReg + "");
                toAddBefore.add(nullTmp);
            }
            if (useInfo.putRelease != null) {
                if (!useInfo.usesAsObj().and(useInfo.allWrites()).isEmpty()) {
                    needsTmpReg = true;
                    throw new ReferenceCountingException("We do not handle the case where a release is made in a x = foo(x) situation because it  hasn't showed up so far");
                }
                toAddBefore.add(useInfo.putRelease);
            }
            for (int oneReg : useInfo.requiresRetain) {
                Element retain = new Element("reg-retain", this.vm);
                retain.setAttribute("reg", oneReg + "");
                toAddAfter.add(retain);
            }
            if (useInfo.freeTmpAfter) {
                Element releaseTmp = new Element("reg-release", this.vm);
                releaseTmp.setAttribute("reg", this.tmpRegNameSuffix);
                toAddAfter.add(releaseTmp);
                needsTmpReg = true;
            }
            toAddAfter.addAll(toReleaseLast);
            this.addBeforeAndAfter(e.getKey(), toAddBefore, toAddAfter);
        }
        return needsTmpReg;
    }

    void addBeforeAndAfter(Element toAddTo, List<Element> toAddBefore, List<Element> toAddAfter) throws ReferenceCountingException {
        Element parent = toAddTo.getParentElement();
        List con = parent.getContent();
        for (int x = 0; x < con.size(); ++x) {
            if (!con.get(x).equals(toAddTo)) continue;
            parent.addContent(x + 1, toAddAfter);
            parent.addContent(x, toAddBefore);
            return;
        }
        throw new ReferenceCountingException("Impossible");
    }

    private void addToNextPrevElement(List<Element> toProcess) throws DataConversionException {
        Element prev = null;
        for (int k = 0; k < toProcess.size(); ++k) {
            Element cur = toProcess.get(k);
            if (cur.getName().equals("label")) {
                this.labels.put(cur.getAttribute("id").getIntValue(), cur);
            }
            if (prev != null) {
                this.nextElement.put(prev, cur);
                this.prevElement.put(cur, prev);
            }
            prev = cur;
        }
    }

    private void processRecStart(int numReg, List<Element> toProcess, Element codeElement) throws DataConversionException, ReferenceCountingException {
        this.addToNextPrevElement(toProcess);
        for (Element element : toProcess) {
            if (!element.getName().equals("try-catch")) continue;
            this.addToNextPrevElement(element.getChild("try", this.dex).getChildren());
            for (Element catchE : element.getChildren("catch", this.dex)) {
                this.addToNextPrevElement(catchE.getChildren());
            }
        }
        this.doMarkup(toProcess);
        this.curRun.allConflict = RegisterSet.none();
        for (Map.Entry entry : this.curRun.beenTo.entrySet()) {
            this.curRun.allConflict.orEq(((InstructionActions)entry.getValue()).getConflict());
        }
        Element parent = toProcess.get(0).getParentElement();
        if (!this.curRun.allConflict.isEmpty()) {
            int n = this.splitConflictedRegisters(numReg, this.curRun.allConflict, this.curRun.beenTo);
            parent.getAttribute("register-size").setValue(n + "");
            this.doMarkup(toProcess);
        }
        ReferenceCounting.refLog("Conflict is: " + this.curRun.allConflict);
        this.setWillFree(this.curRun.beenTo);
        RefCountOptimization.ReturnValue returnValue = new RegisterSizeAndNullingOptimization().Process(this.curRun.allCodePaths, this.curRun.beenTo, codeElement);
        new DeferredNullingOptimization().Process(this.curRun.allCodePaths, this.curRun.beenTo, codeElement);
        toProcess.addAll(0, returnValue.functionInit);
        this.addExTempReg(toProcess);
        this.clearReleaseRetainOnSyntheticMembers(this.curRun, codeElement);
        boolean usesTemp = this.processReleaseRetain(this.curRun.beenTo);
        if (usesTemp) {
            Element setupTmp = new Element("define-register", InstructionProcessor.vm);
            setupTmp.setAttribute("vartype", "temp");
            toProcess.add(0, setupTmp);
        }
    }

    private void clearReleaseRetainOnSyntheticMembers(RunState curRun, Element codeElement) throws DataConversionException {
        Element classElement = codeElement.getParentElement().getParentElement();
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element : classElement.getChildren()) {
            if (!element.getName().equals("field") || element.getAttribute("isSynthetic") == null || !element.getAttributeValue("isSynthetic").equals("true") || !element.getAttributeValue("name").startsWith("this$")) continue;
            hashSet.add(element.getAttributeValue("name"));
        }
        for (Map.Entry entry : curRun.beenTo.entrySet()) {
            String instructionElementName = ((Element)entry.getKey()).getName();
            if (!instructionElementName.equals("iput-object") && !instructionElementName.equals("iput") || ((Element)entry.getKey()).getAttribute("member-name") == null || !hashSet.contains(((Element)entry.getKey()).getAttributeValue("member-name"))) continue;
            InstructionUseInfo useInfo = ((InstructionActions)entry.getValue()).useInfo;
            useInfo.putRelease = null;
            useInfo.requiresRetain = RegisterSet.none();
        }
    }

    private void addExTempReg(List<Element> toProcess) {
        boolean useEx = false;
        boolean useTmp = false;
        for (Element e : this.curRun.beenTo.keySet()) {
            if (e.getName().equals("throw") || e.getName().equals("try-catch")) {
                useEx = true;
            }
            if (!useEx || !useTmp) continue;
            break;
        }
        if (useEx) {
            Element setupEx = new Element("define-register", InstructionProcessor.vm);
            setupEx.setAttribute("vartype", "exception");
            toProcess.add(0, setupEx);
        }
        for (Element e : this.curRun.beenTo.keySet()) {
            if (!e.getName().startsWith("return")) continue;
            e.setAttribute("catchesException", useEx + "");
        }
    }

    private void doMarkup(List<Element> toProcess) throws DataConversionException {
        this.curRun = new RunState();
        this.processRecAdd(RegisterSet.none(), RegisterSet.none(), toProcess.get(0), this.createNewCodePath(null));
        this.processWhileCallsToDo();
    }

    private void printInstSeq(List<Element> toProcess) {
        ReferenceCounting.refLog("All " + toProcess.size() + " instructions been to " + this.curRun.beenTo.size());
        for (Element x : toProcess) {
            if (!this.curRun.beenTo.containsKey(x)) continue;
            String startStr = this.curRun.beenTo.get((Object)x).useInfo + "";
            if (x.getName().equals("label")) {
                ReferenceCounting.refLog(startStr + " ID = " + x.getAttributeValue("id"));
            } else {
                ReferenceCounting.refLog(startStr + "");
            }
            if (!x.getName().equals("try-catch")) continue;
            this.printInstSeq(x.getChild("try", this.dex).getChildren());
        }
    }

    int splitConflictedRegisters(int numReg, RegisterSet allConflict, Map<Element, InstructionActions> beenTo) throws DataConversionException, ReferenceCountingException {
        for (int reg : allConflict) {
            int newReg = numReg++;
            int regObj = reg;
            int regNonObj = newReg;
            for (Element element : beenTo.keySet()) {
                if (!element.getName().equals("var")) continue;
                InstructionUseInfo varUi = this.curRun.beenTo.get((Object)element).useInfo;
                if (!varUi.isWrite) continue;
                if (!varUi.writesObj().isEmpty()) {
                    regObj = reg;
                    regNonObj = newReg;
                    break;
                }
                if (!varUi.writesNonObj().isEmpty()) {
                    regObj = newReg;
                    regNonObj = reg;
                    continue;
                }
                throw new ReferenceCountingException("impossible");
            }
            ReferenceCounting.refLog(reg + " -> o:" + regObj + ":" + regNonObj);
            for (Map.Entry entry : beenTo.entrySet()) {
                InstructionUseInfo ui = ((InstructionActions)entry.getValue()).useInfo;
                for (Map.Entry<Attribute, Boolean> kv : ui.typeIsObj.entrySet()) {
                    if (kv.getKey().getIntValue() != reg) continue;
                    if (kv.getValue().booleanValue()) {
                        kv.getKey().setValue(regObj + "");
                        continue;
                    }
                    kv.getKey().setValue(regNonObj + "");
                }
            }
        }
        return numReg;
    }

    private CodePath createNewCodePath(CodePath curPath) {
        CodePath c = new CodePath(this.curRun.codePathId++, curPath);
        this.curRun.allCodePaths.add(c);
        if (curPath != null) {
            curPath.subPaths.add(c);
        }
        return c;
    }

    private void processRecAdd(RegisterSet regHoldingObject, RegisterSet regNotHoldingObject, Element currentElement, CodePath codePath) throws DataConversionException {
        OneRecusiveCall oneCall = new OneRecusiveCall();
        oneCall.regHoldingObject = regHoldingObject;
        oneCall.regNotHoldingObject = regNotHoldingObject;
        oneCall.currentElement = currentElement;
        oneCall.codePath = codePath;
        this.curRun.callsToDo.add(oneCall);
    }

    private void processWhileCallsToDo() throws DataConversionException {
        int maxSize = 0;
        while (this.curRun.callsToDo.size() != 0) {
            Element nextInstruction;
            InstructionActions actions;
            maxSize = Math.max(maxSize, this.curRun.callsToDo.size());
            OneRecusiveCall thisTime = this.curRun.callsToDo.removeFirst();
            RegisterSet regHoldingObject = thisTime.regHoldingObject;
            RegisterSet regNotHoldingObject = thisTime.regNotHoldingObject;
            Element currentElement = thisTime.currentElement;
            CodePath codePath = thisTime.codePath;
            if (currentElement == null || (actions = ReferenceCounting.beenHereBefore(this.curRun.beenTo, regHoldingObject, regNotHoldingObject, currentElement, codePath)) == null) continue;
            InstructionUseInfo useInfo = actions.useInfo;
            if (currentElement.getName().startsWith("goto")) {
                nextInstruction = this.labels.get(currentElement.getAttribute("target").getIntValue());
            } else {
                nextInstruction = this.nextElement.get(currentElement);
                if (nextInstruction == null && currentElement.getParentElement().getName().equals("try")) {
                    nextInstruction = this.nextElement.get(currentElement.getParentElement().getParentElement());
                }
            }
            RegisterSet ourObjUse = regHoldingObject.clone();
            ourObjUse.orEq(useInfo.writesObj());
            ourObjUse.andEqNot(useInfo.writesNonObj());
            RegisterSet ourNonObjUse = regNotHoldingObject.clone();
            ourNonObjUse.orEq(useInfo.writesNonObj());
            ourNonObjUse.andEqNot(useInfo.writesObj());
            if (currentElement.getName().startsWith("return")) continue;
            if (currentElement.getName().equals("try-catch")) {
                this.processRecAdd(ourObjUse, ourNonObjUse, (Element)currentElement.getChild("try", this.dex).getChildren().get(0), this.createNewCodePath(codePath));
                for (Element caught : currentElement.getChildren("catch", this.dex)) {
                    Element nextInst = this.labels.get(caught.getAttribute("target").getIntValue());
                    this.processRecAdd(ourObjUse, ourNonObjUse, nextInst, this.createNewCodePath(codePath));
                }
                continue;
            }
            if (currentElement.getName().equals("packed-switch") || currentElement.getName().equals("sparse-switch")) {
                this.processRecAdd(ourObjUse, ourNonObjUse, nextInstruction, this.createNewCodePath(codePath));
                for (Element target : currentElement.getChildren("case", this.dex)) {
                    this.processRecAdd(ourObjUse, ourNonObjUse, this.labels.get(target.getAttribute("label").getIntValue()), this.createNewCodePath(codePath));
                }
                continue;
            }
            if (currentElement.getName().startsWith("if")) {
                this.processRecAdd(ourObjUse, ourNonObjUse, nextInstruction, this.createNewCodePath(codePath));
                this.processRecAdd(ourObjUse, ourNonObjUse, this.labels.get(currentElement.getAttribute("target").getIntValue()), this.createNewCodePath(codePath));
                continue;
            }
            if (currentElement.getName().equals("label")) {
                this.processRecAdd(ourObjUse, ourNonObjUse, nextInstruction, this.createNewCodePath(codePath));
                continue;
            }
            this.processRecAdd(ourObjUse, ourNonObjUse, nextInstruction, codePath);
        }
        ReferenceCounting.refLog("Max recusrive depth " + maxSize);
    }

    private static InstructionActions beenHereBefore(Map<Element, InstructionActions> beenTo, RegisterSet regHoldingObject, RegisterSet regNotHoldingObject, Element currentElement, CodePath c) throws DataConversionException {
        InstructionActions toRet;
        if (beenTo.containsKey(currentElement)) {
            toRet = beenTo.get(currentElement);
        } else {
            toRet = new InstructionActions();
            toRet.useInfo = ReferenceCounting.processElement(currentElement);
            beenTo.put(currentElement, toRet);
        }
        if (!currentElement.getName().equals("label")) {
            c.path.add(new OnePathInstructionRegisterContents(currentElement, regHoldingObject, regNotHoldingObject));
        }
        boolean enteredNotHolding = false;
        for (RegisterSet m : toRet.enteredNot) {
            if (!m.equals(regNotHoldingObject)) continue;
            enteredNotHolding = true;
            break;
        }
        boolean enteredHolding = false;
        for (RegisterSet m : toRet.enteredHoldingObj) {
            if (!m.equals(regHoldingObject)) continue;
            enteredHolding = true;
            break;
        }
        if (enteredNotHolding && enteredHolding) {
            return null;
        }
        if (!enteredHolding) {
            toRet.enteredHoldingObj.add(regHoldingObject);
        }
        if (!enteredNotHolding) {
            toRet.enteredNot.add(regNotHoldingObject);
        }
        return toRet;
    }

    private static InstructionUseInfo processElement(Element element) throws DataConversionException {
        InstructionUseInfo use = new InstructionUseInfo(element);
        if (InstructionProcessor.processGeneric(element, use)) {
            return use;
        }
        String todo = "process_" + element.getName().replace("-", "_");
        try {
            Method method = InstructionProcessor.class.getMethod(todo, Element.class, InstructionUseInfo.class);
            method.invoke(null, element, use);
        }
        catch (Exception ex) {
            throw new DataConversionException(ex.getMessage(), "When attempting to: " + todo);
        }
        return use;
    }

    private static void refLog(String message) {
    }

    class OneRecusiveCall {
        RegisterSet regHoldingObject;
        RegisterSet regNotHoldingObject;
        Element currentElement;
        CodePath codePath;

        OneRecusiveCall() {
        }
    }

    class RunState {
        public List<CodePath> allCodePaths = new ArrayList<CodePath>();
        public int codePathId = 0;
        public Map<Element, InstructionActions> beenTo = new HashMap<Element, InstructionActions>();
        public RegisterSet allConflict = RegisterSet.none();
        LinkedList<OneRecusiveCall> callsToDo = new LinkedList();

        RunState() {
        }
    }
}

