/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;

public class FileSet
implements Iterable<File>,
Iterator<File> {
    private File[] fileList;
    private final Stack<File> paths = new Stack();
    private final Pattern wildcard;
    private boolean recurseFolders;
    private Iterator<File> currentIterator;

    public FileSet(String filePattern) {
        File f = new File(filePattern);
        if (f.isDirectory()) {
            f = new File(filePattern + File.separator + "*");
        }
        File path = f.getParentFile() == null ? new File(".") : f.getParentFile();
        this.paths.push(path);
        String regex = "";
        this.recurseFolders = true;
        String fname = f.getName();
        block5: for (int i = 0; i < fname.length(); ++i) {
            switch (fname.charAt(i)) {
                case '.': {
                    regex = regex + "\\.";
                    continue block5;
                }
                case '?': {
                    regex = regex + '.';
                    this.recurseFolders = true;
                    continue block5;
                }
                case '*': {
                    regex = regex + ".*";
                    this.recurseFolders = true;
                    continue block5;
                }
                default: {
                    regex = regex + fname.charAt(i);
                }
            }
        }
        this.wildcard = Pattern.compile(regex);
        this.fillUpFileList();
    }

    private void fillUpFileList() {
        if (this.paths.empty()) {
            this.fileList = null;
            this.currentIterator = new Iterator<File>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public void remove() {
                }

                @Override
                public File next() {
                    return null;
                }
            };
            return;
        }
        File folder = this.paths.pop();
        this.fileList = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (FileSet.this.recurseFolders && pathname.isDirectory()) {
                    FileSet.this.paths.push(pathname);
                }
                return FileSet.this.wildcard.matcher(pathname.getName()).matches();
            }
        });
        this.currentIterator = new Iterator<File>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < FileSet.this.fileList.length;
            }

            @Override
            public File next() {
                return FileSet.this.fileList[this.i++];
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<File> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        while (!this.currentIterator.hasNext() && !this.paths.empty()) {
            this.fillUpFileList();
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            return null;
        }
        return this.currentIterator.next();
    }
}

