/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.analytics;

import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.Method;
import com.android.dx.cf.iface.MethodList;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.dex.code.CatchHandlerList;
import com.android.dx.dex.code.CatchTable;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.HighRegisterPrefix;
import com.android.dx.dex.code.RopTranslator;
import com.android.dx.dex.code.SimpleInsn;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstBaseMethodRef;
import com.android.dx.rop.cst.CstMemberRef;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmlvm.Log;
import org.xmlvm.util.analytics.HierarchyAnalyzer;
import org.xmlvm.util.analytics.Pair;
import org.xmlvm.util.analytics.data.Dependencies;
import org.xmlvm.util.analytics.data.TypeHierarchy;
import org.xmlvm.util.analytics.data.Util;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileCreator;
import org.xmlvm.util.universalfile.UniversalFileFilter;

public class JDKAnalyzer {
    public static final String TAG = JDKAnalyzer.class.getSimpleName();
    public static Map<String, Integer> badClassCount = new HashMap<String, Integer>();
    public static final String RESULTS_FILENAME = "results.bin";
    public static final String RESULTS2_FILENAME = "results2.bin";
    public static final String GRAPH_FILENAME = "fulldeps.gdf";
    static final String[] GOOD_PACKAGES = new String[]{"java.lang", "java.util", "java.math", "java.net", "java.io", "org.apache.harmony.luni.util"};
    public static final Set<String> GOOD_CLASSES = new HashSet<String>();
    public static final Set<String> BAD_CLASSES = new HashSet<String>();

    public static void main(String[] args) {
        if (args.length != 1) {
            Log.error(TAG, "Invalid usage.");
            System.exit(-1);
        }
        JDKAnalyzer.fillGoodBadOverrides();
        String libraryPath = args[0];
        Dependencies dependencies = JDKAnalyzer.loadDepencencies(libraryPath);
        JDKAnalyzer.writeDepsToGraphFile(dependencies);
        HierarchyAnalyzer hierarchyAnalyzer = new HierarchyAnalyzer(libraryPath);
        TypeHierarchy hierarchy = hierarchyAnalyzer.analyze();
        Set<String> mockMethods = JDKAnalyzer.determineGreenMockMethods(dependencies, hierarchy);
        Pair<Set<String>, Set<String>> orangeLists = JDKAnalyzer.constructOrangeList(dependencies);
        Set<String> redList = JDKAnalyzer.constructRedList(dependencies, (Set)orangeLists.first);
        Set<String> greenList = JDKAnalyzer.constructGreenList(dependencies);
        JDKAnalyzer.writeSetToFile((Set)orangeLists.first, "orange_classes.txt");
        JDKAnalyzer.writeSetToFile((Set)orangeLists.second, "orange_details.txt");
        JDKAnalyzer.writeSetToFile(redList, "red.txt");
        JDKAnalyzer.writeSetToFile(greenList, "green.txt");
    }

    private static void fillGoodBadOverrides() {
        GOOD_CLASSES.add("java.security.Permission");
        GOOD_CLASSES.add("java.security.Guard");
        GOOD_CLASSES.add("java.security.PermissionCollection");
        GOOD_CLASSES.add("java.security.BasicPermission");
        GOOD_CLASSES.add("java.security.PrivilegedAction");
        GOOD_CLASSES.add("java.security.PrivilegedActionException");
        GOOD_CLASSES.add("java.security.PrivilegedExceptionAction");
        GOOD_CLASSES.add("sun.reflect.LangReflectAccess");
        GOOD_CLASSES.add("sun.misc.JavaNetAccess");
        GOOD_CLASSES.add("sun.misc.JavaIOAccess");
        GOOD_CLASSES.add("org.xml.sax.EntityResolver");
        GOOD_CLASSES.add("sun.net.spi.nameservice.NameService");
        GOOD_CLASSES.add("org.xml.sax.ErrorHandler");
        GOOD_CLASSES.add("sun.misc.JavaIODeleteOnExitAccess");
        GOOD_CLASSES.add("sun.misc.SignalHandler");
        GOOD_CLASSES.add("sun.misc.JavaLangAccess");
        GOOD_CLASSES.add("sun.misc.JavaUtilJarAccess");
        GOOD_CLASSES.add("sun.misc.JavaIOFileDescriptorAccess");
        GOOD_CLASSES.add("sun.util.LocaleServiceProviderPool$LocalizedObjectGetter");
        GOOD_CLASSES.add("java.nio.channels.Channel");
        GOOD_CLASSES.add("org.apache.harmony.luni.internal.nls.Messages");
        GOOD_CLASSES.add("org.apache.harmony.math.internal.nls.Messages");
        GOOD_CLASSES.add("org.apache.harmony.regex.internal.nls.Messages");
        GOOD_CLASSES.add("org.apache.harmony.archive.internal.nls.Messages");
        BAD_CLASSES.add("java.util.jar.JarVerifier");
        BAD_CLASSES.add("java.lang.management.ManagementFactory");
        BAD_CLASSES.add("java.util.JapaneseImperialCalendar");
        BAD_CLASSES.add("java.lang.ClassLoader");
        BAD_CLASSES.add("java.net.URLClassLoader");
        BAD_CLASSES.add("java.net.URLClassLoader$SubURLClassLoader");
        BAD_CLASSES.add("java.net.FactoryURLClassLoader");
        BAD_CLASSES.add("java.util.ResourceBundle$RBClassLoader");
        BAD_CLASSES.add("java.util.Scanner$1");
        BAD_CLASSES.add("java.io.ObjectStreamClass$OSCThreadLocalCache");
        BAD_CLASSES.add("java.io.ObjectStreamClass$OSCThreadLocalCache$1");
        BAD_CLASSES.add("org.apache.xerces.impl.xpath.regex.ParserForXMLSchema");
    }

    private static Set<String> constructRedList(Dependencies dependencies, Set<String> orangeList) {
        HashSet<String> result = new HashSet<String>();
        for (String clazz : dependencies.keySet()) {
            if (JDKAnalyzer.isGoodClass(clazz) || orangeList.contains(clazz)) continue;
            result.add(clazz);
        }
        return result;
    }

    private static Set<String> constructGreenList(Dependencies dependencies) {
        HashSet<String> result = new HashSet<String>();
        for (String clazz : dependencies.keySet()) {
            if (!JDKAnalyzer.isGoodClass(clazz)) continue;
            result.add(clazz);
        }
        return result;
    }

    private static Pair<Set<String>, Set<String>> constructOrangeList(Dependencies dependencies) {
        HashSet<String> orangeClasses = new HashSet<String>();
        HashSet<String> details = new HashSet<String>();
        for (String clazz : dependencies.keySet()) {
            if (!JDKAnalyzer.isGoodClass(clazz)) continue;
            Dependencies.ClassDeps classDeps = dependencies.getDepsForClass(clazz);
            for (String method : classDeps.methodSet()) {
                Dependencies.MethodDeps methodDeps = classDeps.getMethodDeps(method);
                for (String dep : methodDeps.classSet()) {
                    if (JDKAnalyzer.isGoodClass(dep)) continue;
                    orangeClasses.add(dep);
                    for (String methodDep : methodDeps.getMethods(dep)) {
                        if (methodDep.isEmpty()) continue;
                        details.add(dep + "::" + methodDep);
                    }
                }
            }
        }
        return new Pair<Set<String>, Set<String>>(orangeClasses, details);
    }

    private static void writeDepsToGraphFile(Dependencies dependencies) {
        Log.debug(TAG, "Writing GDF file ...");
        StringBuilder nodeDef = new StringBuilder();
        StringBuilder edgeDef = new StringBuilder();
        nodeDef.append("nodedef> name,color,style\n");
        edgeDef.append("edgedef> node1,node2,method VARCHAR(32)\n");
        HashSet<String> allNodes = new HashSet<String>();
        for (String clazz : dependencies.keySet()) {
            if (!JDKAnalyzer.isGoodClass(clazz)) continue;
            boolean hasDepsToGraph = false;
            Dependencies.ClassDeps classDeps = dependencies.getDepsForClass(clazz);
            for (String method : classDeps.methodSet()) {
                Dependencies.MethodDeps methodDeps = classDeps.getMethodDeps(method);
                for (String dep : methodDeps.classSet()) {
                    if (JDKAnalyzer.isGoodClass(dep)) continue;
                    for (String methodDep : methodDeps.getMethods(dep)) {
                        allNodes.add(dep);
                        edgeDef.append(clazz);
                        edgeDef.append(",");
                        edgeDef.append(dep);
                        edgeDef.append(",");
                        edgeDef.append(method + "->" + methodDep);
                        edgeDef.append("\n");
                        hasDepsToGraph = true;
                    }
                }
            }
            if (!hasDepsToGraph) continue;
            allNodes.add(clazz);
        }
        for (String node : allNodes) {
            nodeDef.append(node);
            if (JDKAnalyzer.isGoodClass(node)) {
                nodeDef.append(",");
                nodeDef.append("blue");
                nodeDef.append(",");
                nodeDef.append("1");
            } else {
                nodeDef.append(",");
                nodeDef.append("red");
                nodeDef.append(",");
                nodeDef.append("2");
            }
            nodeDef.append("\n");
        }
        try {
            FileWriter fw = new FileWriter(GRAPH_FILENAME);
            fw.write(nodeDef.toString());
            fw.write(edgeDef.toString());
            fw.close();
            Log.debug(TAG, "Writing GDF file done.");
        }
        catch (IOException e) {
            Log.error(TAG, "Writing GDF file failed: " + e.getMessage());
        }
    }

    private static void printDirectBadRefs() {
        ArrayList<String> clazzes = new ArrayList<String>(badClassCount.keySet());
        Collections.sort(clazzes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return badClassCount.get(o1) - badClassCount.get(o2);
            }
        });
        Log.debug(TAG, "Top direct bad refs:");
        for (String badDep : clazzes) {
            int count = badClassCount.get(badDep);
            if (count <= 10) continue;
            Log.debug(TAG, count + " - " + badDep);
        }
    }

    private static Set<String> getGoodClassesWithBadReferences(Dependencies data) {
        HashSet<String> result = new HashSet();
        File resultsFile = new File(RESULTS2_FILENAME);
        if (resultsFile.exists()) {
            Log.debug(TAG, "Attempting to read second result from results2.bin");
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(resultsFile));
                result = (Set)ois.readObject();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        int goods = 0;
        for (String className : data.keySet()) {
            if (!JDKAnalyzer.isGoodClass(className)) continue;
            ++goods;
            if (JDKAnalyzer.hasBadDep(className, data)) {
                result.add(className);
                continue;
            }
            Log.debug(TAG, "A good class without bad rep!");
        }
        Log.debug(TAG, "Good classes: " + goods);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(resultsFile));
            oos.writeObject(result);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private static boolean hasBadDep(String className, Dependencies data) {
        boolean result = false;
        block0: for (String dep : data.getAllDepsForClass(className)) {
            for (String goodDep : GOOD_PACKAGES) {
                if (dep.startsWith(goodDep)) continue;
                if (!badClassCount.containsKey(dep)) {
                    badClassCount.put(dep, 0);
                }
                badClassCount.put(dep, badClassCount.get(dep) + 1);
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private static boolean isGoodClass(String className) {
        for (String good : GOOD_CLASSES) {
            if (!className.equals(good)) continue;
            return true;
        }
        for (String bad : BAD_CLASSES) {
            if (!className.equals(bad)) continue;
            return false;
        }
        for (String goodDep : GOOD_PACKAGES) {
            if (!className.startsWith(goodDep)) continue;
            return true;
        }
        return false;
    }

    private static Dependencies loadDepencencies(String jdkFileName) {
        Dependencies dependencies = new Dependencies();
        File resultsFile = new File(RESULTS_FILENAME);
        if (resultsFile.exists()) {
            Log.debug(TAG, "Loading results from results.bin ...");
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(resultsFile));
                dependencies = (Dependencies)ois.readObject();
                ois.close();
                Log.debug(TAG, "Loaded results from file: " + dependencies.size());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        UniversalFile library = UniversalFileCreator.createDirectory(null, jdkFileName);
        UniversalFile[] classes = library.listFilesRecursively(new UniversalFileFilter(){

            @Override
            public boolean accept(UniversalFile file) {
                return file.getName().toLowerCase().endsWith(".class");
            }
        });
        Log.debug(TAG, "Analyzing " + classes.length + " classes.");
        String basePath = library.getAbsolutePath();
        for (UniversalFile clazz : classes) {
            String fileName = clazz.getRelativePath(basePath).replace('\\', '.');
            Dependencies.ClassDeps classDeps = dependencies.getDepsForClass(fileName.substring(0, fileName.length() - 6).replace(File.separatorChar, '.'));
            JDKAnalyzer.getAllDependencies(clazz.getFileAsBytes(), fileName, classDeps);
        }
        try {
            Log.debug(TAG, "Writing result to file results.bin");
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(RESULTS_FILENAME));
            oos.writeObject(dependencies);
            oos.close();
            Log.debug(TAG, "Done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return dependencies;
    }

    private static void getAllDependencies(byte[] bytes, String relativePath, Dependencies.ClassDeps classDeps) {
        int i;
        TypeList interfaces;
        Log.debug(TAG, relativePath);
        DirectClassFile classFile = new DirectClassFile(bytes, relativePath, false);
        classFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        try {
            classFile.getMagic();
        }
        catch (ParseException ex) {
            Log.warn(TAG, "Put to red-list as it couldn't be parsed: " + relativePath);
            BAD_CLASSES.add(classDeps.getClassName());
            return;
        }
        String superClassName = "";
        if (classFile.getSuperclass() != null) {
            superClassName = Util.parseClassName(classFile.getSuperclass().getClassType().getClassName()).toString();
        }
        if (!superClassName.isEmpty()) {
            HashSet<String> superClass = new HashSet<String>();
            superClass.add(superClassName.replace('/', '.'));
            classDeps.getMethodDeps("SUPER").addDependency(superClassName.replace('/', '.'), "");
        }
        if ((interfaces = classFile.getInterfaces()).size() > 0) {
            HashSet<String> interfaceList = new HashSet<String>();
            for (i = 0; i < interfaces.size(); ++i) {
                interfaceList.add(Util.parseClassName(interfaces.getType(i).getClassName()).toString());
                classDeps.getMethodDeps("INTERFACES").addDependency(Util.parseClassName(interfaces.getType(i).getClassName()).toString(), "");
            }
        }
        MethodList methods = classFile.getMethods();
        for (i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            JDKAnalyzer.processCode(JDKAnalyzer.getCode(method, classFile), classDeps.getMethodDeps(method.getName().toHuman()));
        }
    }

    private static void processSignature(CstMethodRef methodRef, Set<String> dependencies) {
        Prototype prototype = methodRef.getPrototype();
        StdTypeList parameters = prototype.getParameterTypes();
        for (int i = 0; i < parameters.size(); ++i) {
            String parameterType = parameters.get(i).toHuman();
            dependencies.add(parameterType);
        }
        dependencies.add(prototype.getReturnType().getType().toHuman());
    }

    private static void processCode(DalvCode code, Dependencies.MethodDeps methodDeps) {
        if (code == null) {
            return;
        }
        DalvInsnList instructions = code.getInsns();
        for (int i = 0; i < instructions.size(); ++i) {
            JDKAnalyzer.processInstruction(instructions.get(i), methodDeps);
        }
    }

    private static void processInstruction(DalvInsn instruction, Dependencies.MethodDeps methodDeps) {
        block5: {
            block3: {
                CstInsn cstInsn;
                block4: {
                    String opname = instruction.getOpcode().getName();
                    if (opname.equals("instance-of") || opname.equals("const-class")) {
                        CstInsn isaInsn = (CstInsn)instruction;
                    }
                    if (!(instruction instanceof CstInsn)) break block3;
                    cstInsn = (CstInsn)instruction;
                    if (!JDKAnalyzer.isInvokeInstruction(cstInsn)) break block4;
                    CstBaseMethodRef methodRef = (CstBaseMethodRef)cstInsn.getConstant();
                    methodDeps.addDependency(methodRef.getDefiningClass().toHuman(), methodRef.getNat().getName().toHuman() + ":" + methodRef.getPrototype().toString());
                    break block5;
                }
                Constant constant = cstInsn.getConstant();
                if (!(constant instanceof CstMemberRef)) break block5;
                CstMemberRef memberRef = (CstMemberRef)constant;
                methodDeps.addDependency(memberRef.getDefiningClass().getClassType().toHuman(), memberRef.getNat().getName().toHuman());
                break block5;
            }
            if (instruction instanceof HighRegisterPrefix) {
                SimpleInsn[] moveInstructions;
                HighRegisterPrefix highRegisterPrefix = (HighRegisterPrefix)instruction;
                for (SimpleInsn moveInstruction : moveInstructions = highRegisterPrefix.getMoveInstructions()) {
                    JDKAnalyzer.processInstruction(moveInstruction, methodDeps);
                }
            }
        }
    }

    private static void processCatchTable(CatchTable catchTable, Map<String, Set<String>> dependencies) {
        if (catchTable.size() == 0) {
            return;
        }
        for (int i = 0; i < catchTable.size(); ++i) {
            CatchTable.Entry entry = catchTable.get(i);
            CatchHandlerList catchHandlers = entry.getHandlers();
            for (int j = 0; j < catchHandlers.size(); ++j) {
            }
        }
    }

    private static boolean isInvokeInstruction(CstInsn cstInsn) {
        Dop[] invokeInstructions;
        for (Dop dop : invokeInstructions = new Dop[]{Dops.INVOKE_VIRTUAL, Dops.INVOKE_VIRTUAL_RANGE, Dops.INVOKE_STATIC, Dops.INVOKE_STATIC_RANGE, Dops.INVOKE_DIRECT, Dops.INVOKE_DIRECT_RANGE, Dops.INVOKE_INTERFACE, Dops.INVOKE_INTERFACE_RANGE, Dops.INVOKE_SUPER, Dops.INVOKE_SUPER_RANGE}) {
            if (!dop.equals(cstInsn.getOpcode())) continue;
            return true;
        }
        return false;
    }

    private static DalvCode getCode(Method method, DirectClassFile classFile) {
        boolean isNative = AccessFlags.isNative(method.getAccessFlags());
        boolean isStatic = AccessFlags.isStatic(method.getAccessFlags());
        boolean isAbstract = AccessFlags.isAbstract(method.getAccessFlags());
        if (isNative || isAbstract) {
            return null;
        }
        ConcreteMethod concrete = new ConcreteMethod(method, classFile, false, false);
        DexTranslationAdvice advice = DexTranslationAdvice.THE_ONE;
        RopMethod rmeth = Ropper.convert(concrete, advice);
        CstMethodRef meth = new CstMethodRef(method.getDefiningClass(), method.getNat());
        int paramSize = meth.getParameterWordCount(isStatic);
        DalvCode code = RopTranslator.translate(rmeth, 1, null, paramSize);
        DalvCode.AssignIndicesCallback callback = new DalvCode.AssignIndicesCallback(){

            @Override
            public int getIndex(Constant cst) {
                return 0;
            }
        };
        code.assignIndices(callback);
        return code;
    }

    private static void writeSetToFile(Set<String> set, String fileName) {
        try {
            FileWriter writer = new FileWriter(fileName);
            for (String item : set) {
                writer.write(item);
                writer.write(10);
            }
            writer.close();
            Log.debug(TAG, "File written: " + fileName);
        }
        catch (IOException e) {
            Log.error(TAG, "Error while writing set to file: " + e.getMessage());
        }
    }

    private static Set<String> determineGreenMockMethods(Dependencies dependencies, TypeHierarchy hierarchy) {
        HashSet<String> result = new HashSet<String>();
        for (String clazz : dependencies.keySet()) {
            Set<String> subClasses;
            if (JDKAnalyzer.isGoodClass(clazz) || (subClasses = hierarchy.getDirectSubTypes(clazz)) == null) continue;
            for (String subClass : subClasses) {
                if (!JDKAnalyzer.isGoodClass(subClass)) continue;
                System.out.println(clazz + " -> " + subClass);
            }
        }
        return result;
    }
}

