/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.skeleton;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class ClassList
extends ArrayList<Class> {
    private String pkg;
    private String canonical_pkg;

    public ClassList(String pkg) {
        this.pkg = pkg.replace(".", "/");
        this.canonical_pkg = pkg.replace("/", ".") + ".";
        this.updateList();
    }

    private void updateList() {
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File file = new File(tok.nextToken());
            if (file.isFile()) {
                this.browseJarFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.browseLocalDir(file, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseJarFile(File f) {
        ZipInputStream libFiles = null;
        int pkglen = this.pkg.length();
        try {
            libFiles = new JarInputStream(new FileInputStream(f));
            JarEntry file = null;
            while ((file = ((JarInputStream)libFiles).getNextJarEntry()) != null) {
                String name = file.getName();
                int lastslash = name.lastIndexOf("/");
                if (lastslash != pkglen || !name.startsWith(this.pkg)) continue;
                this.checkClassName(name.substring(lastslash + 1, name.length()));
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                libFiles.close();
            }
            catch (IOException ex) {}
        }
    }

    private void browseLocalDir(File d, String currentpkg) {
        File[] list;
        if (currentpkg.equals(this.pkg)) {
            File[] list2;
            for (File entry : list2 = d.listFiles()) {
                if (!entry.isFile()) continue;
                this.checkClassName(entry.getName());
            }
            return;
        }
        if (currentpkg.length() >= this.pkg.length()) {
            return;
        }
        if (!this.pkg.startsWith(currentpkg)) {
            return;
        }
        for (File entry : list = d.listFiles()) {
            if (!entry.isDirectory()) continue;
            this.browseLocalDir(entry, currentpkg + (currentpkg.length() == 0 ? "" : "/") + entry.getName());
        }
    }

    private void checkClassName(String name) {
        if (name.endsWith(".class") && name.indexOf(36) < 0) {
            try {
                this.add(Class.forName(this.canonical_pkg + name.substring(0, name.length() - ".class".length())));
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Class reference " + name + " found but unable to initialize.");
            }
        }
    }
}

