/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFileCreator;
import org.xmlvm.util.universalfile.UniversalFileFilter;

public abstract class UniversalFile {
    private static final String TAG = UniversalFile.class.getSimpleName();

    public String getName() {
        String path = this.getAbsolutePath();
        if (path.isEmpty()) {
            return "";
        }
        int startAt = Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1;
        if (startAt <= 0) {
            return "";
        }
        return path.substring(startAt);
    }

    public abstract String getAbsolutePath();

    public String getRelativePath(String basePath) {
        String fullPath = this.getAbsolutePath();
        if (!fullPath.startsWith(basePath)) {
            Log.error("'" + basePath + "' is not a base path of '" + fullPath);
            return null;
        }
        String result = fullPath.substring(basePath.length());
        if (result.startsWith(File.separator)) {
            result = result.substring(1);
        }
        return result;
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean exists();

    public abstract long getLastModified();

    public abstract UniversalFile[] listFiles();

    public UniversalFile[] listFiles(UniversalFileFilter filter) {
        UniversalFile[] allFiles = this.listFiles();
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        for (UniversalFile file : allFiles) {
            if (!filter.accept(file)) continue;
            result.add(file);
        }
        return result.toArray(new UniversalFile[0]);
    }

    public UniversalFile[] listFilesRecursively(UniversalFileFilter filter) {
        UniversalFile[] all = this.listFilesRecursively();
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        for (UniversalFile file : all) {
            if (!filter.accept(file)) continue;
            result.add(file);
        }
        return result.toArray(new UniversalFile[0]);
    }

    public UniversalFile[] listFilesRecursively() {
        if (!this.isDirectory()) {
            return new UniversalFile[0];
        }
        ArrayList<UniversalFile> result = new ArrayList<UniversalFile>();
        for (UniversalFile file : this.listFiles()) {
            if (file.isFile()) {
                result.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            result.addAll(Arrays.asList(file.listFilesRecursively()));
        }
        return result.toArray(new UniversalFile[0]);
    }

    public UniversalFile getEntry(String name) {
        UniversalFile[] allFiles;
        if (!this.isDirectory()) {
            return null;
        }
        for (UniversalFile file : allFiles = this.listFiles()) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    public abstract byte[] getFileAsBytes();

    public abstract String getFileAsString();

    public boolean saveAs(String path) {
        if (this.isFile()) {
            return this.saveFileAs(path);
        }
        if (this.isDirectory()) {
            return this.saveDirectoryAs(path);
        }
        return false;
    }

    public boolean archiveTo(String destination, String pathPrefix) {
        if (!pathPrefix.isEmpty() && !pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix + "/";
        }
        if (this.isFile()) {
            return this.archiveFileTo(destination, pathPrefix);
        }
        if (this.isDirectory()) {
            return this.archiveDirectoryTo(destination, pathPrefix);
        }
        return false;
    }

    public boolean isEmpty() {
        if (!this.exists()) {
            return true;
        }
        if (this.isDirectory()) {
            return false;
        }
        return this.getFileAsBytes().length == 0;
    }

    public boolean isDifferentFromExisting(String destinationPath) {
        byte[] existingData;
        UniversalFile destination = UniversalFileCreator.createFile(new File(destinationPath));
        if (!destination.exists() || !destination.isFile()) {
            return true;
        }
        byte[] newData = this.getFileAsBytes();
        if (newData.length != (existingData = destination.getFileAsBytes()).length) {
            return true;
        }
        for (int i = 0; i < newData.length; ++i) {
            if (newData[i] == existingData[i]) continue;
            return true;
        }
        return false;
    }

    private boolean saveFileAs(String path) {
        try {
            File parent = new File(path).getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                return false;
            }
            FileOutputStream outputStream = new FileOutputStream(path);
            outputStream.write(this.getFileAsBytes());
            outputStream.close();
            return true;
        }
        catch (FileNotFoundException e) {
            Log.error(TAG, "Could not save file at: " + path + "(" + e.getMessage() + ")");
        }
        catch (IOException e) {
            Log.error(TAG, "Could not save file at: " + path + "(" + e.getMessage() + ")");
        }
        return false;
    }

    private boolean saveDirectoryAs(String destination) {
        File destinationFile = new File(destination);
        if (destinationFile.exists() && destinationFile.isFile()) {
            Log.error(TAG, "Could not copy files to " + destination + ". Destination is a file.");
            return false;
        }
        String destinationStr = destinationFile.getAbsolutePath();
        for (UniversalFile file : this.listFiles()) {
            if (file.isFile()) {
                file.saveAs(destinationStr + File.separatorChar + file.getName());
                continue;
            }
            if (!file.isDirectory()) continue;
            String absolutePath = file.getAbsolutePath();
            String directoryName = absolutePath.substring(absolutePath.lastIndexOf(File.separatorChar) + 1);
            file.saveAs(destinationStr + File.separatorChar + directoryName);
        }
        return true;
    }

    private boolean archiveFileTo(String destination, String pathPrefix) {
        File destinationFile = UniversalFile.prepareDestinationArchive(destination);
        if (destinationFile == null) {
            return false;
        }
        try {
            JarOutputStream outputStream = new JarOutputStream(new FileOutputStream(destinationFile));
            outputStream.putNextEntry(new ZipEntry(pathPrefix + this.getName()));
            outputStream.write(this.getFileAsBytes());
            outputStream.close();
            return true;
        }
        catch (FileNotFoundException e) {
            Log.error(TAG, "Could not create JarOutputStream: " + e.getMessage());
        }
        catch (IOException e) {
            Log.error(TAG, "Could not create JarOutputStream: " + e.getMessage());
        }
        return false;
    }

    private boolean archiveDirectoryTo(String destination, String pathPrefix) {
        JarOutputStream outputStream;
        File destinationFile = UniversalFile.prepareDestinationArchive(destination);
        if (destinationFile == null) {
            return false;
        }
        try {
            outputStream = new JarOutputStream(new FileOutputStream(destinationFile));
        }
        catch (FileNotFoundException e) {
            Log.error(TAG, "Could not create JarOutputStream: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            Log.error(TAG, "Could not create JarOutputStream: " + e.getMessage());
            return false;
        }
        String basePath = this.getAbsolutePath();
        UniversalFile[] filesToArchive = this.listFilesRecursively();
        try {
            for (UniversalFile fileToArchive : filesToArchive) {
                String path = fileToArchive.getAbsolutePath();
                if (!path.startsWith(basePath)) {
                    Log.error(TAG, "Internal error: File in directory has wrong path:");
                    Log.error(TAG, "Base path: " + basePath);
                    Log.error(TAG, "File path: " + path);
                    return false;
                }
                path = path.substring(basePath.length() + 1);
                String entryPath = (pathPrefix + path).replace('\\', '/');
                outputStream.putNextEntry(new ZipEntry(entryPath));
                outputStream.write(fileToArchive.getFileAsBytes());
            }
            outputStream.close();
            return true;
        }
        catch (IOException e) {
            Log.error(TAG, "Could not write to archive: " + e.getMessage());
            return false;
        }
    }

    private static File prepareDestinationArchive(String destination) {
        boolean created;
        File parentDirectory;
        File destinationFile = new File(destination);
        if (destinationFile.exists()) {
            if (destinationFile.isDirectory()) {
                Log.error(TAG, "Cannot write archive, destination is a directory: " + destination);
                return null;
            }
            boolean deleted = destinationFile.delete();
            if (!deleted) {
                Log.error(TAG, "Unable to delete existing file: " + destination);
                return null;
            }
        }
        if (!(parentDirectory = destinationFile.getParentFile()).exists() && !(created = parentDirectory.mkdirs())) {
            Log.error(TAG, "Could not create directory: " + parentDirectory.getAbsolutePath());
            return null;
        }
        return destinationFile;
    }

    public String toString() {
        return this.getAbsolutePath();
    }
}

