/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileFromFileSystemDirectory;
import org.xmlvm.util.universalfile.UniversalFileFromFileSystemFile;
import org.xmlvm.util.universalfile.UniversalFileFromJarFile;
import org.xmlvm.util.universalfile.UniversalFileFromMemory;
import org.xmlvm.util.universalfile.UniversalFileFromStreamResource;

public class UniversalFileCreator {
    private static final String TAG = "UniversalFileCreator";

    private UniversalFileCreator() {
    }

    public static UniversalFile createFile(File location) {
        if (location.isDirectory()) {
            return new UniversalFileFromFileSystemDirectory(location);
        }
        if (location.isFile()) {
            return new UniversalFileFromFileSystemFile(location);
        }
        Log.debug(TAG, "Location is neither a file nor a directory: " + location.getAbsolutePath());
        return null;
    }

    public static UniversalFile createFile(String absoluteName, InputStream stream, long lastModified) {
        return new UniversalFileFromStreamResource(absoluteName, stream, lastModified);
    }

    public static UniversalFile createFile(String absoluteName, byte[] data, long lastModified) {
        return new UniversalFileFromMemory(absoluteName, data, lastModified);
    }

    public static UniversalFile createFile(String absoluteName, byte[] data) {
        return UniversalFileCreator.createFile(absoluteName, data, System.currentTimeMillis());
    }

    public static UniversalFile createFile(String oneJarResource, String fileSystemLocation) {
        return UniversalFileCreator.create(oneJarResource, fileSystemLocation, false);
    }

    public static UniversalFile createDirectory(String oneJarResourceJar, String fileSystemLocation) {
        return UniversalFileCreator.create(oneJarResourceJar, fileSystemLocation, true);
    }

    public static UniversalFile createDirectory(String fileSystemLocation) {
        return UniversalFileCreator.create(null, fileSystemLocation, true);
    }

    private static UniversalFile create(String oneJarResource, String fileSystemLocation, boolean isDirectory) {
        UniversalFile oneJar = null;
        UniversalFile fileSystem = null;
        if (oneJarResource != null) {
            oneJar = UniversalFileCreator.getOneJarResource(oneJarResource, isDirectory);
        }
        if (fileSystemLocation != null) {
            fileSystem = UniversalFileCreator.getFileSystemResource(fileSystemLocation, isDirectory);
        }
        if (oneJar != null) {
            return oneJar;
        }
        if (fileSystem != null) {
            return fileSystem;
        }
        Log.debug(TAG, "Could not find either resource: (One-JAR resource: " + oneJarResource + " / file system resource: " + fileSystemLocation + ")");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UniversalFile getOneJarResource(String oneJarResource, boolean isDirectory) {
        InputStream stream = UniversalFileCreator.class.getResourceAsStream(oneJarResource);
        if (stream == null) {
            return null;
        }
        if (!isDirectory) return new UniversalFileFromStreamResource(oneJarResource, stream, System.currentTimeMillis());
        if (!oneJarResource.toLowerCase().endsWith(".jar") && !oneJarResource.toLowerCase().endsWith(".zip")) {
            Log.error(TAG, "For a directory, the One-JAR resource must be a jar archive, but is: " + oneJarResource);
            return null;
        }
        try {
            return new UniversalFileFromJarFile(oneJarResource, new JarInputStream(stream));
        }
        catch (IOException e) {
            Log.error(TAG, "Could not create JarInputStream for One-JAR resource: " + oneJarResource);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UniversalFile getFileSystemResource(String fileSystemLocation, boolean isDirectory) {
        boolean fileSystemIsJar;
        File file = new File(fileSystemLocation);
        String fileName = file.getName().toLowerCase();
        boolean bl = fileSystemIsJar = file.isFile() && (fileName.endsWith(".jar") || fileName.endsWith(".zip"));
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory() != isDirectory && fileSystemIsJar != isDirectory) {
            if (isDirectory && !fileSystemIsJar) {
                Log.error(TAG, "Attempt to create directory, but file system resource is not a directory or JAR file: " + fileSystemLocation);
                return null;
            } else {
                Log.error(TAG, "Attempt to create file, but file system resource is not a file: " + fileSystemLocation);
            }
            return null;
        }
        if (!isDirectory) return new UniversalFileFromFileSystemFile(file);
        if (!fileSystemIsJar) return new UniversalFileFromFileSystemDirectory(file);
        try {
            return new UniversalFileFromJarFile(fileSystemLocation, new JarInputStream(new FileInputStream(fileSystemLocation)));
        }
        catch (IOException e) {
            Log.error(TAG, "Could not read: " + fileSystemLocation);
            return null;
        }
    }
}

