/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.xmlvm.Log;
import org.xmlvm.util.universalfile.UniversalFile;
import org.xmlvm.util.universalfile.UniversalFileDirectory;
import org.xmlvm.util.universalfile.UniversalFileFromStreamResource;

public class UniversalFileFromJarFile
extends UniversalFile {
    private static final String TAG = "UniversalFileFromJarFile";
    private String absoluteName;
    private JarInputStream jarStream;
    private UniversalFileDirectory directory;
    private long lastModified;

    UniversalFileFromJarFile(String absoluteName, JarInputStream jarStream) {
        this.absoluteName = absoluteName;
        this.jarStream = jarStream;
        this.lastModified = this.calcLastModified();
    }

    private long calcLastModified() {
        File file = new File(this.absoluteName);
        if (file.exists()) {
            return file.lastModified();
        }
        return System.currentTimeMillis();
    }

    @Override
    public String getAbsolutePath() {
        return this.absoluteName;
    }

    @Override
    public byte[] getFileAsBytes() {
        return null;
    }

    @Override
    public String getFileAsString() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public synchronized UniversalFile[] listFiles() {
        if (this.directory == null) {
            this.directory = this.initialize();
        }
        return this.directory.listFiles();
    }

    private synchronized UniversalFileDirectory initialize() {
        UniversalFileDirectory result = new UniversalFileDirectory(this.absoluteName, this.lastModified);
        try {
            JarEntry entry;
            byte[] data = new byte[4096];
            while ((entry = this.jarStream.getNextJarEntry()) != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                int len = 0;
                while ((len = this.jarStream.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                }
                this.put(result, entry.getName(), new ByteArrayInputStream(outputStream.toByteArray()), entry.getTime());
            }
        }
        catch (IOException e) {
            Log.error(TAG, "Error reading JAR file: " + this.absoluteName);
        }
        return result;
    }

    private synchronized void put(UniversalFileDirectory addToDir, String name, InputStream stream, long entryLastModified) {
        int index;
        while ((index = name.indexOf("/")) != -1) {
            String subDirName = name.substring(0, index);
            if (!subDirName.isEmpty()) {
                UniversalFileDirectory subDirectory = addToDir.getDirectory(subDirName);
                if (subDirectory == null) {
                    subDirectory = new UniversalFileDirectory(addToDir.getAbsolutePath() + File.separator + subDirName, entryLastModified);
                    addToDir.add(subDirectory);
                }
                addToDir = subDirectory;
            }
            name = name.substring(index + 1);
        }
        if (!name.isEmpty()) {
            addToDir.add(new UniversalFileFromStreamResource(addToDir.getAbsolutePath() + File.separator + name, stream, entryLastModified));
        }
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

