/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.UnsupportedEncodingException;
import org.xmlvm.util.universalfile.UniversalFile;

public class UniversalFileFromMemory
extends UniversalFile {
    private final String absoluteName;
    private final byte[] data;
    private final long lastModified;

    UniversalFileFromMemory(String absoluteName, byte[] data) {
        this(absoluteName, data, System.currentTimeMillis());
    }

    UniversalFileFromMemory(String absoluteName, byte[] data, long lastModified) {
        this.absoluteName = absoluteName;
        this.data = data;
        this.lastModified = lastModified;
    }

    @Override
    public String getAbsolutePath() {
        return this.absoluteName;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean exists() {
        return this.data != null;
    }

    @Override
    public UniversalFile[] listFiles() {
        return new UniversalFile[0];
    }

    @Override
    public byte[] getFileAsBytes() {
        return this.data;
    }

    @Override
    public String getFileAsString() {
        try {
            return new String(this.data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.data);
        }
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

