/*
 * Decompiled with CFR 0.152.
 */
package org.xmlvm.util.universalfile;

import java.io.InputStream;
import org.xmlvm.util.FileUtil;
import org.xmlvm.util.universalfile.UniversalFile;

public class UniversalFileFromStreamResource
extends UniversalFile {
    private final String absoluteName;
    private final InputStream stream;
    private final long lastModified;
    private byte[] cachedBytes = null;
    private String cachedString = null;

    UniversalFileFromStreamResource(String absoluteName, InputStream stream, long lastModified) {
        this.absoluteName = absoluteName;
        this.stream = stream;
        this.lastModified = lastModified;
    }

    @Override
    public String getAbsolutePath() {
        return this.absoluteName;
    }

    @Override
    public byte[] getFileAsBytes() {
        if (this.cachedBytes == null) {
            this.initContent();
        }
        return this.cachedBytes;
    }

    @Override
    public String getFileAsString() {
        if (this.cachedString == null) {
            this.initContent();
        }
        return this.cachedString;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public UniversalFile[] listFiles() {
        return new UniversalFile[0];
    }

    private void initContent() {
        this.cachedBytes = FileUtil.readBytesFromStream(this.stream);
        this.cachedString = new String(this.cachedBytes);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

