/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.facebook.presto.jdbc.internal.joda.time.Duration;
import java.io.IOException;

public class DurationSerializer
extends JodaDateSerializerBase<Duration> {
    private static final long serialVersionUID = 1L;

    public DurationSerializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DurationSerializer(JacksonJodaDateFormat formatter) {
        super(Duration.class, formatter, false, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    public DurationSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new DurationSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Duration value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(value.toString());
        }
    }
}

