/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.FixedWidthBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.DecimalType;
import com.facebook.presto.jdbc.internal.spi.type.Decimals;
import com.facebook.presto.jdbc.internal.spi.type.SqlDecimal;
import com.facebook.presto.jdbc.internal.spi.type.UnscaledDecimal128Arithmetic;

final class LongDecimalType
extends DecimalType {
    LongDecimalType(int precision, int scale) {
        super(precision, scale, Slice.class);
        this.validatePrecisionScale(precision, scale, 38);
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), blockBuilderStatus, Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new FixedWidthBlockBuilder(this.getFixedSize(), positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, this.getFixedSize());
        return new SqlDecimal(Decimals.decodeUnscaledValue(slice), this.getPrecision(), this.getScale());
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.compareTo(leftBlock, leftPosition, rightBlock, rightPosition) == 0;
    }

    @Override
    public long hash(Block block, int position) {
        long low = block.getLong(position, 0);
        long high = block.getLong(position, 8);
        return UnscaledDecimal128Arithmetic.hash(low, high);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftLow = leftBlock.getLong(leftPosition, 0);
        long leftHigh = leftBlock.getLong(leftPosition, 8);
        long rightLow = rightBlock.getLong(rightPosition, 0);
        long rightHigh = rightBlock.getLong(rightPosition, 8);
        return UnscaledDecimal128Arithmetic.compare(leftLow, leftHigh, rightLow, rightHigh);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, this.getFixedSize(), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }
}

