/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.sunchenbin.mybatis.actable.utils;

import com.gitee.sunchenbin.mybatis.actable.utils.ColumnUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class FieldUtils {
    public static <T> Field getKeyField(T obj) {
        Field[] allFields;
        for (Field field : allFields = FieldUtils.getAllFields(obj)) {
            field.setAccessible(true);
            if (!ColumnUtils.isKey(field, obj.getClass())) continue;
            return field;
        }
        return null;
    }

    public static <T> Field[] getAllFields(T obj) {
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        declaredFields = FieldUtils.recursionParents(obj.getClass(), declaredFields);
        return declaredFields;
    }

    public static Field[] recursionParents(Class<?> clas, Field[] fields) {
        if (clas.getSuperclass() != null) {
            Class<?> clsSup = clas.getSuperclass();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            fieldList.addAll(Arrays.asList(fields));
            fieldList.addAll(Arrays.asList(clsSup.getDeclaredFields()));
            fields = new Field[fieldList.size()];
            int i = 0;
            for (Object field : fieldList.toArray()) {
                fields[i] = (Field)field;
                ++i;
            }
            fields = FieldUtils.recursionParents(clsSup, fields);
        }
        return fields;
    }
}

