/*
 * Decompiled with CFR 0.152.
 */
package com.github.madgnome.maven.h2spec;

import com.github.madgnome.maven.h2spec.Failure;
import com.github.madgnome.maven.h2spec.H2SpecTestSuite;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="h2spec", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class Http2SpecMojo
extends AbstractMojo {
    @Parameter(defaultValue="-1", property="port", required=true)
    private int port;
    @Parameter(defaultValue="2", property="timeout")
    private int timeout;
    @Parameter(defaultValue="4000", property="maxHeaderLength")
    private int maxHeaderLength;
    @Parameter(property="excludeSpecs")
    private List<String> excludeSpecs;
    @Parameter(property="mainClass", required=true)
    private String mainClass;
    @Parameter(property="waitTime")
    private long waitTime;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Component
    private MavenProject project;

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getTestClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution of h2spec-maven-plugin");
            return;
        }
        final AtomicReference error = new AtomicReference();
        Thread runner = null;
        try {
            String host;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.getLog().debug((CharSequence)"Unable to detect localhost address, using 127.0.0.1 as fallback");
                host = "127.0.0.1";
            }
            if (this.port == -1) {
                this.port = this.findRandomOpenPortOnAllLocalInterfaces();
            }
            runner = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(Http2SpecMojo.this.getClassLoader());
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(Http2SpecMojo.this.mainClass);
                        Method main = clazz.getMethod("main", String[].class);
                        main.invoke(null, new Object[]{new String[]{String.valueOf(Http2SpecMojo.this.port)}});
                    }
                    catch (Exception e) {
                        error.set(e);
                    }
                }
            });
            runner.setDaemon(true);
            runner.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            if (this.waitTime <= 0L) {
                this.waitTime = 10000L;
            }
            long sleepTime = this.waitTime / 10L;
            for (int i = 0; i < 10; ++i) {
                Throwable cause = (Throwable)error.get();
                if (cause != null) {
                    throw new MojoExecutionException("Unable to start server", cause);
                }
                Socket socket = new Socket();
                try {
                    socket.connect(new InetSocketAddress(host, this.port));
                    break;
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
                if (i != 9) continue;
                throw new MojoExecutionException("Unable to connect to server in " + this.waitTime, (Exception)error.get());
            }
            if (this.excludeSpecs == null) {
                this.excludeSpecs = Collections.emptyList();
            }
            try {
                this.getLog().info((CharSequence)"!!! Exclude specs");
                for (String excludeSpec : this.excludeSpecs) {
                    this.getLog().info((CharSequence)excludeSpec);
                }
                File outputDirectory = new File(this.project.getBuild().getTestOutputDirectory());
                List<Failure> allFailures = H2SpecTestSuite.runH2Spec(this.getLog(), outputDirectory, this.port, this.timeout, this.maxHeaderLength, new HashSet<String>(this.excludeSpecs));
                ArrayList<Failure> nonIgnoredFailures = new ArrayList<Failure>();
                ArrayList<Failure> ignoredFailures = new ArrayList<Failure>();
                for (Failure failure : allFailures) {
                    if (failure.isIgnored()) {
                        ignoredFailures.add(failure);
                        continue;
                    }
                    nonIgnoredFailures.add(failure);
                }
                if (nonIgnoredFailures.size() > 0) {
                    StringBuilder sb = new StringBuilder("\nFailed test cases:\n");
                    for (Failure failure : nonIgnoredFailures) {
                        sb.append("\t");
                        sb.append(failure.toString());
                        sb.append("\n\n");
                    }
                    throw new MojoFailureException(sb.toString());
                }
                this.getLog().info((CharSequence)("All test cases passed. " + ignoredFailures.size() + " test cases ignored."));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (runner != null) {
                runner.interrupt();
            }
        }
    }

    private Integer findRandomOpenPortOnAllLocalInterfaces() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            Integer n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't find an open socket", e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    System.err.println("Can't close server socket.");
                }
            }
        }
    }
}

