/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.cache.impl.OneShotExecutionCallback;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CallbackAwareClientDelegatingFuture<V>
extends ClientDelegatingFuture<V> {
    private final OneShotExecutionCallback<V> callback;

    CallbackAwareClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, OneShotExecutionCallback<V> callback) {
        super(clientInvocationFuture, serializationService, clientMessageDecoder);
        this.callback = callback;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            Object result = super.get();
            this.callback.onResponse(result);
            return result;
        }
        catch (Throwable t) {
            this.callback.onFailure(t);
            return (V)ExceptionUtil.sneakyThrow((Throwable)t);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long finishTime;
        long l = finishTime = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : Clock.currentTimeMillis() + unit.toMillis(timeout);
        if (finishTime < 0L) {
            finishTime = Long.MAX_VALUE;
        }
        try {
            Object result = super.get(timeout, unit);
            this.callback.onResponse(result, finishTime);
            return result;
        }
        catch (Throwable t) {
            this.callback.onFailure(t, finishTime);
            return (V)ExceptionUtil.sneakyThrow((Throwable)t);
        }
    }
}

