/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.io.IOException;

public class SmartClientInvocationService
extends AbstractClientInvocationService {
    private final LoadBalancer loadBalancer;

    public SmartClientInvocationService(HazelcastClientInstanceImpl client, LoadBalancer loadBalancer) {
        super(client);
        this.loadBalancer = loadBalancer;
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        Address owner = this.partitionService.getPartitionOwner(partitionId);
        if (owner == null) {
            throw new IOException("Partition does not have an owner. partitionId: " + partitionId);
        }
        if (!this.isMember(owner)) {
            throw new TargetNotMemberException("Partition owner '" + owner + "' is not a member.");
        }
        invocation.getClientMessage().setPartitionId(partitionId);
        Connection connection = this.getOrTriggerConnect(owner);
        this.send(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        Address randomAddress = this.getRandomAddress();
        if (randomAddress == null) {
            throw new IOException("No address found to invoke");
        }
        Connection connection = this.getOrTriggerConnect(randomAddress);
        this.send(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        assert (target != null);
        if (!this.isMember(target)) {
            throw new TargetNotMemberException("Target '" + target + "' is not a member.");
        }
        Connection connection = this.getOrTriggerConnect(target);
        this.invokeOnConnection(invocation, (ClientConnection)connection);
    }

    private Connection getOrTriggerConnect(Address target) throws IOException {
        Connection connection = this.connectionManager.getOrTriggerConnect(target);
        if (connection == null) {
            throw new IOException("No available connection to address " + target);
        }
        return connection;
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        this.send(invocation, connection);
    }

    private Address getRandomAddress() {
        Member member = this.loadBalancer.next();
        if (member != null) {
            return member.getAddress();
        }
        return null;
    }

    boolean isMember(Address target) {
        Member member = this.client.getClientClusterService().getMember(target);
        return member != null;
    }
}

