/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.collection.attr.AttributeValueConverter;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.typeconvert.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractReadOnlyAttributeContainer<KEYTYPE, VALUETYPE>
implements IAttributeContainer<KEYTYPE, VALUETYPE> {
    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE KEYTYPE) {
        return (DATATYPE)GenericReflection.uncheckedCast(this.getAttributeObject(KEYTYPE));
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE KEYTYPE, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getCastedAttribute(KEYTYPE);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<DATATYPE> clazz) {
        return TypeConverter.convertIfNecessary(this.getAttributeObject(KEYTYPE), clazz);
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<DATATYPE> clazz, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getTypedAttribute(KEYTYPE, clazz);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsString(KEYTYPE, null);
    }

    @Nullable
    @Deprecated
    public static String getAsString(@Nullable Object object, @Nullable Object object2, @Nullable String string) {
        return AttributeValueConverter.getAsString(object, object2, string);
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable KEYTYPE KEYTYPE, @Nullable String string) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsString(KEYTYPE, VALUETYPE, string);
    }

    @Deprecated
    public static int getAsInt(@Nullable Object object, @Nullable Object object2, int n) {
        return AttributeValueConverter.getAsInt(object, object2, n);
    }

    @Override
    public final int getAttributeAsInt(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsInt(KEYTYPE, -1);
    }

    @Override
    public final int getAttributeAsInt(@Nullable KEYTYPE KEYTYPE, int n) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsInt(KEYTYPE, VALUETYPE, n);
    }

    @Deprecated
    public static long getAsLong(@Nullable Object object, @Nullable Object object2, long l) {
        return AttributeValueConverter.getAsLong(object, object2, l);
    }

    @Override
    public final long getAttributeAsLong(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsLong(KEYTYPE, -1L);
    }

    @Override
    public final long getAttributeAsLong(@Nullable KEYTYPE KEYTYPE, long l) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsLong(KEYTYPE, VALUETYPE, l);
    }

    @Deprecated
    public static double getAsDouble(@Nullable Object object, @Nullable Object object2, double d) {
        return AttributeValueConverter.getAsDouble(object, object2, d);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsDouble(KEYTYPE, -1.0);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable KEYTYPE KEYTYPE, double d) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsDouble(KEYTYPE, VALUETYPE, d);
    }

    @Deprecated
    public static boolean getAsBoolean(@Nullable Object object, @Nullable Object object2, boolean bl) {
        return AttributeValueConverter.getAsBoolean(object, object2, bl);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBoolean(KEYTYPE, false);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable KEYTYPE KEYTYPE, boolean bl) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsBoolean(KEYTYPE, VALUETYPE, bl);
    }

    @Nullable
    @Deprecated
    public static BigInteger getAsBigInteger(@Nullable Object object, @Nullable Object object2, @Nullable BigInteger bigInteger) {
        return AttributeValueConverter.getAsBigInteger(object, object2, bigInteger);
    }

    @Override
    @Nullable
    public final BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBigInteger(KEYTYPE, null);
    }

    @Override
    @Nullable
    public final BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE KEYTYPE, @Nullable BigInteger bigInteger) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsBigInteger(KEYTYPE, VALUETYPE, bigInteger);
    }

    @Nullable
    @Deprecated
    public static BigDecimal getAsBigDecimal(@Nullable Object object, @Nullable Object object2, @Nullable BigDecimal bigDecimal) {
        return AttributeValueConverter.getAsBigDecimal(object, object2, bigDecimal);
    }

    @Override
    @Nullable
    public final BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBigDecimal(KEYTYPE, null);
    }

    @Override
    @Nullable
    public final BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE KEYTYPE, @Nullable BigDecimal bigDecimal) {
        Object VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsBigDecimal(KEYTYPE, VALUETYPE, bigDecimal);
    }
}

