/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.exception;

import com.helger.commons.exception.ILoggedException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedIOException
extends IOException
implements ILoggedException {
    public static final boolean DEFAULT_DO_LOG = true;
    public static final String MSG_TEXT = "IOException created.";
    private static final Logger s_aLogger = LoggerFactory.getLogger((String)"ROOT");

    public LoggedIOException() {
        this(true);
    }

    public LoggedIOException(boolean bl) {
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedIOException(@Nullable String string) {
        this(true, string);
    }

    public LoggedIOException(boolean bl, @Nullable String string) {
        super(string);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedIOException(@Nullable Throwable throwable) {
        this(true, throwable);
    }

    public LoggedIOException(boolean bl, @Nullable Throwable throwable) {
        super(throwable);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedIOException(@Nullable String string, @Nullable Throwable throwable) {
        this(true, string, throwable);
    }

    public LoggedIOException(boolean bl, @Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    @Nonnull
    public static IOException newException(@Nullable Throwable throwable) {
        if (throwable instanceof LoggedIOException) {
            return (LoggedIOException)throwable;
        }
        if (throwable instanceof ILoggedException) {
            return new IOException(throwable);
        }
        return new LoggedIOException(throwable);
    }

    @Nonnull
    public static IOException newException(@Nullable String string, @Nullable Throwable throwable) {
        if (throwable instanceof LoggedIOException) {
            return (LoggedIOException)throwable;
        }
        if (throwable instanceof ILoggedException) {
            return new IOException(string, throwable);
        }
        return new LoggedIOException(string, throwable);
    }
}

