/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.i18n;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.i18n.CodepointHelper;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Codepoint
implements Serializable,
Comparable<Codepoint> {
    private final int m_nValue;

    public Codepoint(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        this(CharsetManager.getAsString(byArray, charset));
    }

    private static int _getValueFromCharSequence(@Nonnull CharSequence charSequence) {
        ValueEnforcer.notNull(charSequence, "CharSequence");
        int n = charSequence.length();
        if (n == 1) {
            return charSequence.charAt(0);
        }
        if (n > 2) {
            throw new IllegalArgumentException("Too many chars: " + charSequence);
        }
        return Character.toCodePoint(charSequence.charAt(0), charSequence.charAt(1));
    }

    public Codepoint(@Nonnull CharSequence charSequence) {
        this(Codepoint._getValueFromCharSequence(charSequence));
    }

    public Codepoint(@Nonnull String string) {
        this(string.toCharArray());
    }

    private static int _getValueFromCharArray(@Nonnull char[] cArray) {
        ValueEnforcer.notEmpty(cArray, "CharArray");
        int n = cArray.length;
        if (n == 1) {
            return cArray[0];
        }
        if (n > 2) {
            throw new IllegalArgumentException("Too many chars: " + Arrays.toString(cArray));
        }
        return Character.toCodePoint(cArray[0], cArray[1]);
    }

    public Codepoint(@Nonnull char[] cArray) {
        this(Codepoint._getValueFromCharArray(cArray));
    }

    public Codepoint(char c) {
        this((int)c);
    }

    public Codepoint(char c, char c2) {
        this(Character.toCodePoint(c, c2));
    }

    public Codepoint(@Nonnull Codepoint codepoint) {
        this(codepoint.m_nValue);
    }

    public Codepoint(@Nonnegative int n) {
        if (!Character.isValidCodePoint(n)) {
            throw new IllegalArgumentException("Invalid Codepoint: " + n);
        }
        this.m_nValue = n;
    }

    @Nonnegative
    public int getValue() {
        return this.m_nValue;
    }

    public boolean isSupplementary() {
        return Character.isSupplementaryCodePoint(this.m_nValue);
    }

    public boolean isLowSurrogate() {
        return Character.isLowSurrogate((char)this.m_nValue);
    }

    public boolean isHighSurrogate() {
        return Character.isHighSurrogate((char)this.m_nValue);
    }

    public char getHighSurrogate() {
        return CodepointHelper.getHighSurrogate(this.m_nValue);
    }

    public char getLowSurrogate() {
        return CodepointHelper.getLowSurrogate(this.m_nValue);
    }

    public boolean isBidi() {
        return CodepointHelper.isBidi(this.m_nValue);
    }

    public boolean isDigit() {
        return CodepointHelper.isDigit(this.m_nValue);
    }

    public boolean isAlpha() {
        return CodepointHelper.isAlpha(this.m_nValue);
    }

    public boolean isAlphaDigit() {
        return CodepointHelper.isAlpha(this.m_nValue);
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        return CodepointHelper.getAsString(this.m_nValue);
    }

    @Nonnull
    @ReturnsMutableCopy
    public char[] getAsChars() {
        return CodepointHelper.getAsCharArray(this.m_nValue);
    }

    @Nonnegative
    public int getCharCount() {
        return Character.charCount(this.m_nValue);
    }

    @Nonnull
    public byte[] getAsBytes(@Nonnull Charset charset) {
        return CharsetManager.getAsBytes(this.getAsString(), charset);
    }

    public int getPlane() {
        return this.m_nValue / 65536;
    }

    @Nonnull
    public Codepoint next() {
        if (this.m_nValue == 0x10FFFF) {
            throw new IndexOutOfBoundsException();
        }
        return new Codepoint(this.m_nValue + 1);
    }

    @Nonnull
    public Codepoint previous() {
        if (this.m_nValue == 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Codepoint(this.m_nValue - 1);
    }

    @Override
    public int compareTo(@Nonnull Codepoint codepoint) {
        return CompareHelper.compare(this.m_nValue, codepoint.m_nValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Codepoint codepoint = (Codepoint)object;
        return this.m_nValue == codepoint.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }
}

