/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileFilterFilenameStartsWith
extends AbstractFileFilter {
    private final String m_sPrefix;

    public FileFilterFilenameStartsWith(@Nonnull @Nonempty String string) {
        this.m_sPrefix = ValueEnforcer.notEmpty(string, "Prefix");
    }

    @Nonnull
    @Nonempty
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    public boolean matchesThisFilter(@Nullable File file) {
        String string;
        if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
            return string.startsWith(this.m_sPrefix);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileFilterFilenameStartsWith fileFilterFilenameStartsWith = (FileFilterFilenameStartsWith)object;
        return this.m_sPrefix.equals(fileFilterFilenameStartsWith.m_sPrefix);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sPrefix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("prefix", this.m_sPrefix).toString();
    }
}

