/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.io.stream.WrappedOutputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingOutputStream
extends WrappedOutputStream {
    private long m_nBytesWritten = 0L;

    public CountingOutputStream(@Nonnull OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        ++this.m_nBytesWritten;
    }

    @Nonnegative
    public long getBytesWritten() {
        return this.m_nBytesWritten;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesWritten", this.m_nBytesWritten).toString();
    }
}

