/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.string.StringHelper;
import com.helger.commons.system.ENewLineMode;
import com.helger.commons.system.SystemProperties;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassPathHelper {
    private static final ClassPathHelper s_aInstance = new ClassPathHelper();

    private ClassPathHelper() {
    }

    @Nonnull
    public static List<String> getAllClassPathEntries() {
        return StringHelper.getExploded(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath());
    }

    public static void getAllClassPathEntries(@Nonnull Collection<String> collection) {
        StringHelper.getExploded(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath(), -1, collection);
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream) {
        ClassPathHelper.printClassPathEntries(printStream, ENewLineMode.DEFAULT.getText());
    }

    public static void printClassPathEntries(@Nonnull PrintStream printStream, @Nonnull String string) {
        for (String string2 : ClassPathHelper.getAllClassPathEntries()) {
            printStream.print(string2);
            printStream.print(string);
        }
    }
}

