/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.display;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.AbstractCollatingComparator;
import com.helger.commons.text.display.IDisplayTextProvider;
import java.text.Collator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CollatingComparatorDisplayTextProvider<DATATYPE>
extends AbstractCollatingComparator<DATATYPE> {
    private final IDisplayTextProvider<DATATYPE> m_aDisplayTextProvider;
    private final Locale m_aContentLocale;

    public CollatingComparatorDisplayTextProvider(@Nullable Locale locale, @Nonnull IDisplayTextProvider<DATATYPE> iDisplayTextProvider, @Nonnull Locale locale2) {
        super(locale);
        this.m_aDisplayTextProvider = ValueEnforcer.notNull(iDisplayTextProvider, "DisplayTextProvider");
        this.m_aContentLocale = ValueEnforcer.notNull(locale2, "ContentLocale");
    }

    public CollatingComparatorDisplayTextProvider(@Nonnull Collator collator, @Nonnull IDisplayTextProvider<DATATYPE> iDisplayTextProvider, @Nonnull Locale locale) {
        super(collator);
        this.m_aDisplayTextProvider = ValueEnforcer.notNull(iDisplayTextProvider, "DisplayTextProvider");
        this.m_aContentLocale = ValueEnforcer.notNull(locale, "ContentLocale");
    }

    @Nonnull
    public IDisplayTextProvider<DATATYPE> getDisplayTextProvider() {
        return this.m_aDisplayTextProvider;
    }

    @Nonnull
    public Locale getContentLocale() {
        return this.m_aContentLocale;
    }

    @Override
    protected String getPart(@Nonnull DATATYPE DATATYPE) {
        return this.m_aDisplayTextProvider.getDisplayText(DATATYPE, this.m_aContentLocale);
    }
}

