/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.ListBasedStoredMessageCollection;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.store.StoredMessageCollection;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.UIDFolder;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.search.SearchTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

class HierarchicalFolder
implements MailFolder,
UIDFolder {
    private static final Flags PERMANENT_FLAGS = new Flags();
    private final StoredMessageCollection mailMessages = new ListBasedStoredMessageCollection();
    private final List<FolderListener> _mailboxListeners = Collections.synchronizedList(new ArrayList());
    protected String name;
    private final Collection<HierarchicalFolder> children = new CopyOnWriteArrayList<HierarchicalFolder>();
    private HierarchicalFolder parent;
    private boolean isSelectable = false;
    private final AtomicLong nextUid = new AtomicLong(1L);
    private final long uidValidity;

    protected HierarchicalFolder(HierarchicalFolder parent, String name) {
        this.name = name;
        this.parent = parent;
        this.uidValidity = System.currentTimeMillis() / 1000L;
        if (this.uidValidity >= 0xFFFFFFFEL) {
            throw new IllegalStateException("UIDVALIDITY value " + this.uidValidity + " does not fit as unsigned 32 bit int " + 0xFFFFFFFEL);
        }
    }

    public Collection<HierarchicalFolder> getChildren() {
        return this.children;
    }

    public HierarchicalFolder getParent() {
        return this.parent;
    }

    void moveToNewParent(HierarchicalFolder newParent) {
        if (!newParent.children.contains(this)) {
            this.parent = newParent;
            this.parent.children.add(this);
        }
    }

    HierarchicalFolder getChild(String name) {
        for (HierarchicalFolder child : this.children) {
            if (!child.getName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    HierarchicalFolder createChild(String mailboxName) {
        HierarchicalFolder child = new HierarchicalFolder(this, mailboxName);
        this.children.add(child);
        return child;
    }

    void removeChild(HierarchicalFolder toDelete) {
        this.children.remove(toDelete);
    }

    boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFullName() {
        return this.parent.getFullName() + '.' + this.name;
    }

    @Override
    public Flags getPermanentFlags() {
        return PERMANENT_FLAGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMessageCount() {
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            return this.mailMessages.size();
        }
    }

    @Override
    public long getUidValidity() {
        return this.uidValidity;
    }

    @Override
    public long getUidNext() {
        return this.getUIDNext();
    }

    @Override
    public long getUIDNext() {
        return this.nextUid.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnseenCount() {
        int count = 0;
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            for (StoredMessage message : this.mailMessages) {
                if (message.isSet(Flags.Flag.SEEN)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public int getFirstUnseen() {
        return this.mailMessages.getFirstUnseen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRecentCount(boolean reset) {
        int count = 0;
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            for (StoredMessage message : this.mailMessages) {
                if (!message.isSet(Flags.Flag.RECENT)) continue;
                ++count;
                if (!reset) continue;
                message.setFlag(Flags.Flag.RECENT, false);
            }
        }
        return count;
    }

    @Override
    public int getMsn(long uid) throws FolderException {
        return this.mailMessages.getMsn(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalDeletion() {
        List<FolderListener> list = this._mailboxListeners;
        synchronized (list) {
            for (FolderListener listener : this._mailboxListeners) {
                listener.mailboxDeleted();
            }
        }
    }

    @Override
    public List<StoredMessage> getMessages(MsgRangeFilter range) {
        return this.mailMessages.getMessages(range);
    }

    @Override
    public List<StoredMessage> getMessages() {
        return this.mailMessages.getMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoredMessage> getNonDeletedMessages() {
        ArrayList<StoredMessage> ret = new ArrayList<StoredMessage>();
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            for (StoredMessage mailMessage : this.mailMessages) {
                if (mailMessage.getFlags().contains(Flags.Flag.DELETED)) continue;
                ret.add(mailMessage);
            }
        }
        return ret;
    }

    @Override
    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean selectable) {
        this.isSelectable = selectable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long appendMessage(MimeMessage message, Flags flags, Date receivedDate) {
        int newMsn;
        long uid = this.nextUid.getAndIncrement();
        try {
            message.setFlags(flags, true);
            message.setFlag(Flags.Flag.RECENT, true);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not set flags", e);
        }
        StoredMessage storedMessage = new StoredMessage(message, receivedDate, uid);
        Iterable<StoredMessage> iterable = this.mailMessages;
        synchronized (iterable) {
            this.mailMessages.add(storedMessage);
            newMsn = this.mailMessages.size();
        }
        iterable = this._mailboxListeners;
        synchronized (iterable) {
            for (FolderListener _mailboxListener : this._mailboxListeners) {
                _mailboxListener.added(newMsn);
            }
        }
        return uid;
    }

    @Override
    public void setFlags(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
        int msn = this.getMsn(uid);
        StoredMessage message = this.mailMessages.get(msn - 1);
        message.setFlags(flags, value);
        Long uidNotification = null;
        if (addUid) {
            uidNotification = uid;
        }
        this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
    }

    @Override
    public void replaceFlags(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
        int msn = this.getMsn(uid);
        StoredMessage message = this.mailMessages.get(msn - 1);
        message.setFlags(MessageFlags.ALL_FLAGS, false);
        message.setFlags(flags, true);
        Long uidNotification = null;
        if (addUid) {
            uidNotification = uid;
        }
        this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFlagUpdate(int msn, Flags flags, Long uidNotification, FolderListener silentListener) {
        List<FolderListener> list = this._mailboxListeners;
        synchronized (list) {
            for (FolderListener listener : this._mailboxListeners) {
                if (listener == silentListener) continue;
                listener.flagsUpdated(msn, flags, uidNotification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllMessages() {
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            this.mailMessages.clear();
        }
    }

    @Override
    public void store(MovingMessage mail) {
        this.store(mail.getMessage());
    }

    @Override
    public void store(MimeMessage message) {
        Date receivedDate = new Date();
        Flags flags = new Flags();
        this.appendMessage(message, flags, receivedDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredMessage getMessage(long uid) {
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            for (StoredMessage mailMessage : this.mailMessages) {
                if (mailMessage.getUid() != uid) continue;
                return mailMessage;
            }
        }
        return null;
    }

    @Override
    public long[] getMessageUids() {
        return this.mailMessages.getMessageUids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] search(SearchTerm searchTerm) {
        int i;
        ArrayList<StoredMessage> matchedMessages = new ArrayList<StoredMessage>();
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            for (i = 0; i < this.mailMessages.size(); ++i) {
                StoredMessage mailMessage = this.mailMessages.get(i);
                mailMessage.updateMessageNumber(i + 1);
                if (!searchTerm.match((Message)mailMessage.getMimeMessage())) continue;
                matchedMessages.add(mailMessage);
            }
        }
        long[] matchedUids = new long[matchedMessages.size()];
        for (i = 0; i < matchedUids.length; ++i) {
            long uid;
            StoredMessage storedMessage = (StoredMessage)matchedMessages.get(i);
            matchedUids[i] = uid = storedMessage.getUid();
        }
        return matchedUids;
    }

    @Override
    public long copyMessage(long uid, MailFolder toFolder) throws FolderException {
        MimeMessage newMime;
        StoredMessage originalMessage = this.getMessage(uid);
        try {
            newMime = new MimeMessage(originalMessage.getMimeMessage());
        }
        catch (MessagingException e) {
            throw new FolderException("Can not copy message " + uid + " to folder " + toFolder, (Exception)((Object)e));
        }
        return toFolder.appendMessage(newMime, originalMessage.getFlags(), originalMessage.getReceivedDate());
    }

    @Override
    public void expunge() {
        this.mailMessages.expunge(this._mailboxListeners);
    }

    @Override
    public void expunge(IdRange[] idRanges) {
        this.mailMessages.expunge(this._mailboxListeners, idRanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FolderListener listener) {
        List<FolderListener> list = this._mailboxListeners;
        synchronized (list) {
            this._mailboxListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FolderListener listener) {
        List<FolderListener> list = this._mailboxListeners;
        synchronized (list) {
            this._mailboxListeners.remove(listener);
        }
    }

    public String toString() {
        return "HierarchicalFolder{name='" + this.name + '\'' + ", parent=" + this.parent + ", isSelectable=" + this.isSelectable + '}';
    }

    public long getUIDValidity() {
        return this.getUidValidity();
    }

    public Message getMessageByUID(long uid) {
        return this.getMessage(uid).getMimeMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getMessagesByUID(long start, long end) {
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>();
            for (StoredMessage mailMessage : this.mailMessages) {
                long uid = mailMessage.getUid();
                if (uid < start || uid > end) continue;
                messages.add(mailMessage.getMimeMessage());
            }
            return messages.toArray(new Message[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getMessagesByUID(long[] uids) {
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>(uids.length);
            HashMap<Long, StoredMessage> uid2Msg = new HashMap<Long, StoredMessage>(this.mailMessages.size());
            for (StoredMessage mailMessage : this.mailMessages) {
                uid2Msg.put(mailMessage.getUid(), mailMessage);
            }
            for (Object uid : (Object)uids) {
                StoredMessage storedMessage = (StoredMessage)uid2Msg.get((long)uid);
                if (storedMessage == null) continue;
                messages.add(storedMessage.getMimeMessage());
            }
            return messages.toArray(new Message[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUID(Message message) {
        StoredMessageCollection storedMessageCollection = this.mailMessages;
        synchronized (storedMessageCollection) {
            for (StoredMessage mailMessage : this.mailMessages) {
                if (mailMessage.getMimeMessage() != message) continue;
                return mailMessage.getUid();
            }
        }
        throw new IllegalStateException("No match found for " + message);
    }

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }
}

