/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.font.scale;

import com.kennycason.kumo.font.scale.FontScalar;

public class LogFontScalar
implements FontScalar {
    private final int minFont;
    private final int maxFont;

    public LogFontScalar(int minFont, int maxFont) {
        this.minFont = minFont;
        this.maxFont = maxFont;
    }

    @Override
    public float scale(int value, int minValue, int maxValue) {
        double leftSpan = Math.sqrt(maxValue) - Math.sqrt(minValue);
        double rightSpan = this.maxFont - this.minFont;
        double valueScaled = (Math.log(value) - Math.log(minValue)) / leftSpan;
        return (float)((double)this.minFont + valueScaled * rightSpan);
    }
}

