/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.cloud.components;

import com.lframework.starter.cloud.resp.ApiInvokeResult;
import com.lframework.starter.common.exceptions.BaseException;
import com.lframework.starter.common.exceptions.impl.DefaultClientException;
import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.ReflectUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.utils.JsonUtil;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        try {
            ApiInvokeResult result;
            String resp = Util.toString((Reader)response.body().asReader());
            if (log.isDebugEnabled()) {
                log.debug("\u5f00\u59cb\u5904\u7406Feign\u5f02\u5e38\u8bf7\u6c42, methodKey={}, resp={}", (Object)methodKey, (Object)resp);
            }
            if (StringUtil.isEmpty((CharSequence)(result = (ApiInvokeResult)JsonUtil.parseObject((String)resp, ApiInvokeResult.class)).getExClass())) {
                return new DefaultClientException(result.getMsg());
            }
            return (Exception)ReflectUtil.newInstance(Class.forName(result.getExClass()), (Object[])new Object[]{result.getMsg()});
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                if (log.isDebugEnabled()) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                return e;
            }
            log.error(e.getMessage(), (Throwable)e);
            return new DefaultSysException(e.getMessage());
        }
    }
}

