/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.common.security;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import com.lframework.starter.web.common.security.AbstractUserDetails;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;

public class SecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);
    private static final ThreadLocal<AbstractUserDetails> LOGIN_POOL = new ThreadLocal();

    public static void removeCurrentUser() {
        LOGIN_POOL.remove();
    }

    public static AbstractUserDetails getCurrentUser() {
        try {
            if (RequestContextHolder.currentRequestAttributes() == null) {
                return LOGIN_POOL.get();
            }
        }
        catch (Exception e) {
            return LOGIN_POOL.get();
        }
        try {
            SaSession session = StpUtil.getSession((boolean)false);
            if (session == null) {
                return null;
            }
            return (AbstractUserDetails)session.get("user_info_key");
        }
        catch (SaTokenException e) {
            return null;
        }
    }

    public static void setCurrentUser(AbstractUserDetails user) {
        LOGIN_POOL.set(user);
    }

    public static AbstractUserDetails getCurrentUser(Authentication authentication) {
        return SecurityUtil.getCurrentUser();
    }

    public static void logout() {
        StpUtil.logout();
    }

    public static Integer getCurrentTenantId() {
        AbstractUserDetails currentUser = SecurityUtil.getCurrentUser();
        return currentUser == null ? null : currentUser.getTenantId();
    }

    public static AbstractUserDetails getUserByToken(String token) {
        if (token == null) {
            return null;
        }
        try {
            Object loginId = StpUtil.getLoginIdByToken((String)token);
            if (loginId == null) {
                return null;
            }
            SaSession session = StpUtil.getSessionByLoginId((Object)loginId);
            if (session == null) {
                return null;
            }
            return (AbstractUserDetails)session.get("user_info_key");
        }
        catch (SaTokenException e) {
            return null;
        }
    }
}

