/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.common.utils;

import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.env.Environment;

public class ApplicationUtil
implements ApplicationContextAware {
    private static ApplicationContext APPLICATION_CONTEXT;

    public static Object safeGetBean(String beanName) {
        try {
            return APPLICATION_CONTEXT.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static <T> T safeGetBean(Class<T> clazz) {
        try {
            return (T)APPLICATION_CONTEXT.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static Object getBean(String beanName) {
        return APPLICATION_CONTEXT.getBean(beanName);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)APPLICATION_CONTEXT.getBean(clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return APPLICATION_CONTEXT.getBeansOfType(clazz);
    }

    public static void publishEvent(ApplicationEvent event) {
        APPLICATION_CONTEXT.publishEvent(event);
    }

    public static String getProperty(String key) {
        return APPLICATION_CONTEXT.getEnvironment().getProperty(key);
    }

    public static String getRequiredProperty(String key) {
        return APPLICATION_CONTEXT.getEnvironment().getRequiredProperty(key);
    }

    public static String resolvePlaceholders(String s) {
        return APPLICATION_CONTEXT.getEnvironment().resolvePlaceholders(s);
    }

    public static void validate(Object obj) {
        Validator validator = ApplicationUtil.getBean(Validator.class);
        Set errors = validator.validate(obj, new Class[0]);
        if (errors != null && errors.size() > 0) {
            throw new ConstraintViolationException("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff01", errors);
        }
    }

    public static Environment getEnv() {
        return APPLICATION_CONTEXT.getEnvironment();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        APPLICATION_CONTEXT = applicationContext;
    }
}

