/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.exception.FallbackInvocationException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GenericCommand
extends AbstractHystrixCommand<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericCommand.class);

    public GenericCommand(HystrixCommandBuilder builder) {
        super(builder);
    }

    @Override
    protected Object run() throws Exception {
        LOGGER.debug("execute command: {}", (Object)this.getCommandKey().name());
        return this.process(new AbstractHystrixCommand.Action(){

            @Override
            Object execute() {
                return GenericCommand.this.getCommandAction().execute(GenericCommand.this.getExecutionType());
            }
        });
    }

    @Override
    protected Object getFallback() {
        if (this.getFallbackAction() != null) {
            final CommandAction commandAction = this.getFallbackAction();
            try {
                return this.process(new AbstractHystrixCommand.Action(){

                    @Override
                    Object execute() {
                        return commandAction.execute(ExecutionType.SYNCHRONOUS);
                    }
                });
            }
            catch (Throwable e) {
                LOGGER.error(AbstractHystrixCommand.FallbackErrorMessageBuilder.create().append(commandAction, e).build());
                throw new FallbackInvocationException(e.getCause());
            }
        }
        return super.getFallback();
    }
}

