/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.Server;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class AbstractServerPredicate
implements Predicate<PredicateKey> {
    protected IRule rule;
    private volatile LoadBalancerStats lbStats;
    private final Random random = new Random();
    private final AtomicInteger nextIndex = new AtomicInteger();
    private final Predicate<Server> serverOnlyPredicate = new Predicate<Server>(){

        public boolean apply(@Nullable Server input) {
            return AbstractServerPredicate.this.apply(new PredicateKey(input));
        }
    };

    public static AbstractServerPredicate alwaysTrue() {
        return new AbstractServerPredicate(){

            public boolean apply(@Nullable PredicateKey input) {
                return true;
            }
        };
    }

    public AbstractServerPredicate() {
    }

    public AbstractServerPredicate(IRule rule) {
        this.rule = rule;
    }

    public AbstractServerPredicate(IRule rule, IClientConfig clientConfig) {
        this.rule = rule;
    }

    public AbstractServerPredicate(LoadBalancerStats lbStats, IClientConfig clientConfig) {
        this.lbStats = lbStats;
    }

    protected LoadBalancerStats getLBStats() {
        if (this.lbStats != null) {
            return this.lbStats;
        }
        if (this.rule != null) {
            ILoadBalancer lb = this.rule.getLoadBalancer();
            if (lb instanceof AbstractLoadBalancer) {
                LoadBalancerStats stats = ((AbstractLoadBalancer)lb).getLoadBalancerStats();
                this.setLoadBalancerStats(stats);
                return stats;
            }
            return null;
        }
        return null;
    }

    public void setLoadBalancerStats(LoadBalancerStats stats) {
        this.lbStats = stats;
    }

    public Predicate<Server> getServerOnlyPredicate() {
        return this.serverOnlyPredicate;
    }

    public List<Server> getEligibleServers(List<Server> servers) {
        return this.getEligibleServers(servers, null);
    }

    public List<Server> getEligibleServers(List<Server> servers, Object loadBalancerKey) {
        if (loadBalancerKey == null) {
            return ImmutableList.copyOf((Iterable)Iterables.filter(servers, this.getServerOnlyPredicate()));
        }
        ArrayList results = Lists.newArrayList();
        for (Server server : servers) {
            if (!this.apply(new PredicateKey(loadBalancerKey, server))) continue;
            results.add(server);
        }
        return results;
    }

    private int incrementAndGetModulo(int modulo) {
        int next;
        int current;
        while (!this.nextIndex.compareAndSet(current = this.nextIndex.get(), next = (current + 1) % modulo)) {
        }
        return current;
    }

    public Optional<Server> chooseRandomlyAfterFiltering(List<Server> servers) {
        List<Server> eligible = this.getEligibleServers(servers);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)eligible.get(this.random.nextInt(eligible.size())));
    }

    public Optional<Server> chooseRoundRobinAfterFiltering(List<Server> servers) {
        List<Server> eligible = this.getEligibleServers(servers);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)eligible.get(this.incrementAndGetModulo(eligible.size())));
    }

    public Optional<Server> chooseRandomlyAfterFiltering(List<Server> servers, Object loadBalancerKey) {
        List<Server> eligible = this.getEligibleServers(servers, loadBalancerKey);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)eligible.get(this.random.nextInt(eligible.size())));
    }

    public Optional<Server> chooseRoundRobinAfterFiltering(List<Server> servers, Object loadBalancerKey) {
        List<Server> eligible = this.getEligibleServers(servers, loadBalancerKey);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of((Object)eligible.get(this.incrementAndGetModulo(eligible.size())));
    }

    public static AbstractServerPredicate ofKeyPredicate(final Predicate<PredicateKey> p) {
        return new AbstractServerPredicate(){

            @SuppressWarnings(value={"NP"})
            public boolean apply(PredicateKey input) {
                return p.apply((Object)input);
            }
        };
    }

    public static AbstractServerPredicate ofServerPredicate(final Predicate<Server> p) {
        return new AbstractServerPredicate(){

            @SuppressWarnings(value={"NP"})
            public boolean apply(PredicateKey input) {
                return p.apply((Object)input.getServer());
            }
        };
    }
}

