/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.sse;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufProcessor;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import io.reactivex.netty.protocol.http.sse.TooLongFieldNameException;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSentEventDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ServerSentEventDecoder.class);
    public static final int DEFAULT_MAX_FIELD_LENGTH = 100;
    private static final char[] EVENT_ID_FIELD_NAME = "event".toCharArray();
    private static final char[] DATA_FIELD_NAME = "data".toCharArray();
    private static final char[] ID_FIELD_NAME = "id".toCharArray();
    protected static final ByteBufProcessor SKIP_LINE_DELIMITERS_AND_SPACES_PROCESSOR = new ByteBufProcessor(){

        public boolean process(byte value) throws Exception {
            return ServerSentEventDecoder.isLineDelimiter((char)value) || (char)value == ' ';
        }
    };
    protected static final ByteBufProcessor SKIP_COLON_AND_WHITE_SPACE_PROCESSOR = new ByteBufProcessor(){

        public boolean process(byte value) throws Exception {
            char valueChar = (char)value;
            return valueChar == ':' || valueChar == ' ';
        }
    };
    protected static final ByteBufProcessor SCAN_COLON_PROCESSOR = new ByteBufProcessor(){

        public boolean process(byte value) throws Exception {
            return (char)value != ':';
        }
    };
    protected static final ByteBufProcessor SCAN_EOL_PROCESSOR = new ByteBufProcessor(){

        public boolean process(byte value) throws Exception {
            return !ServerSentEventDecoder.isLineDelimiter((char)value);
        }
    };
    private static Charset sseEncodingCharset;
    private final int maxFieldNameLength;
    private ByteBuf lastEventId;
    private ByteBuf lastEventType;
    private ByteBuf incompleteData;
    private ServerSentEvent.Type currentFieldType;
    private State state = State.ReadFieldName;

    public ServerSentEventDecoder() {
        this(100);
    }

    public ServerSentEventDecoder(int maxFieldNameLength) {
        this.maxFieldNameLength = maxFieldNameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (null == sseEncodingCharset) {
            throw new IllegalArgumentException("Can not read SSE data as UTF-8 charset is not available.");
        }
        block14: while (in.isReadable()) {
            int readerIndexAtStart = in.readerIndex();
            switch (this.state) {
                case SkipColonAndWhiteSpaces: {
                    ServerSentEventDecoder.skipColonAndWhiteSapaces(in);
                    this.state = State.ReadFieldValue;
                    break;
                }
                case SkipLineDelimitersAndSpaces: {
                    ServerSentEventDecoder.skipLineDelimiters(in);
                    this.state = State.ReadFieldName;
                    break;
                }
                case ReadFieldName: {
                    ByteBuf fieldNameBuffer;
                    int indexOfColon = ServerSentEventDecoder.scanAndFindColon(in);
                    if (-1 == indexOfColon) {
                        int bytesReceivedTillNow;
                        int n = bytesReceivedTillNow = null != this.incompleteData ? this.incompleteData.readableBytes() : in.readableBytes() - readerIndexAtStart;
                        if (bytesReceivedTillNow > this.maxFieldNameLength) {
                            if (null != this.incompleteData) {
                                this.incompleteData.release();
                                this.incompleteData = null;
                            }
                            throw new TooLongFieldNameException("Too long field name for a server sent event. Field name length received till now: " + bytesReceivedTillNow);
                        }
                        if (null == this.incompleteData) {
                            this.incompleteData = ctx.alloc().buffer(this.maxFieldNameLength, this.maxFieldNameLength);
                        }
                        this.incompleteData.writeBytes(in);
                        break;
                    }
                    int fieldNameLengthInTheCurrentBuffer = indexOfColon - readerIndexAtStart;
                    if (null != this.incompleteData) {
                        in.readBytes(this.incompleteData, fieldNameLengthInTheCurrentBuffer);
                        fieldNameBuffer = this.incompleteData;
                        this.incompleteData = null;
                    } else {
                        fieldNameBuffer = ctx.alloc().buffer(fieldNameLengthInTheCurrentBuffer, fieldNameLengthInTheCurrentBuffer);
                        in.readBytes(fieldNameBuffer, fieldNameLengthInTheCurrentBuffer);
                    }
                    this.state = State.SkipColonAndWhiteSpaces;
                    try {
                        this.currentFieldType = ServerSentEventDecoder.readCurrentFieldTypeFromBuffer(fieldNameBuffer);
                        continue block14;
                    }
                    finally {
                        fieldNameBuffer.release();
                        continue block14;
                    }
                }
                case ReadFieldValue: {
                    int endOfLineStartIndex = ServerSentEventDecoder.scanAndFindEndOfLine(in);
                    if (-1 == endOfLineStartIndex) {
                        if (null == this.incompleteData) {
                            this.incompleteData = ctx.alloc().buffer(in.readableBytes());
                        }
                        this.incompleteData.writeBytes(in);
                        break;
                    }
                    int bytesAvailableInThisIteration = endOfLineStartIndex - readerIndexAtStart;
                    if (null == this.incompleteData) {
                        this.incompleteData = ctx.alloc().buffer(bytesAvailableInThisIteration, bytesAvailableInThisIteration);
                    }
                    this.incompleteData.writeBytes(in, bytesAvailableInThisIteration);
                    switch (this.currentFieldType) {
                        case Data: {
                            if (this.incompleteData.isReadable()) {
                                out.add(ServerSentEvent.withEventIdAndType(this.lastEventId, this.lastEventType, this.incompleteData));
                                break;
                            }
                            this.incompleteData.release();
                            break;
                        }
                        case Id: {
                            if (this.incompleteData.isReadable()) {
                                this.lastEventId = this.incompleteData;
                                break;
                            }
                            this.incompleteData.release();
                            this.lastEventId = null;
                            break;
                        }
                        case EventType: {
                            if (this.incompleteData.isReadable()) {
                                this.lastEventType = this.incompleteData;
                                break;
                            }
                            this.incompleteData.release();
                            this.lastEventType = null;
                        }
                    }
                    this.incompleteData = null;
                    this.state = State.SkipLineDelimitersAndSpaces;
                }
            }
        }
    }

    private static ServerSentEvent.Type readCurrentFieldTypeFromBuffer(ByteBuf fieldNameBuffer) {
        ServerSentEvent.Type toReturn = ServerSentEvent.Type.Data;
        int readableBytes = fieldNameBuffer.readableBytes();
        int readerIndexAtStart = fieldNameBuffer.readerIndex();
        char[] fieldNameToVerify = DATA_FIELD_NAME;
        boolean verified = false;
        int actualFieldNameIndexToCheck = 0;
        block5: for (int i = readerIndexAtStart; i < readableBytes; ++i) {
            char charAtI = (char)fieldNameBuffer.getByte(i);
            if (i == readerIndexAtStart) {
                switch (charAtI) {
                    case 'e': {
                        fieldNameToVerify = EVENT_ID_FIELD_NAME;
                        toReturn = ServerSentEvent.Type.EventType;
                        continue block5;
                    }
                    case 'd': {
                        fieldNameToVerify = DATA_FIELD_NAME;
                        toReturn = ServerSentEvent.Type.Data;
                        continue block5;
                    }
                    case 'i': {
                        fieldNameToVerify = ID_FIELD_NAME;
                        toReturn = ServerSentEvent.Type.Id;
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal Server Sent event field name: " + fieldNameBuffer.toString(sseEncodingCharset));
                    }
                }
            }
            if (++actualFieldNameIndexToCheck >= fieldNameToVerify.length || charAtI != fieldNameToVerify[actualFieldNameIndexToCheck]) {
                verified = false;
                break;
            }
            verified = true;
        }
        if (verified) {
            return toReturn;
        }
        throw new IllegalArgumentException("Illegal Server Sent event field name: " + fieldNameBuffer.toString(sseEncodingCharset));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (null != this.lastEventId) {
            this.lastEventId.release();
        }
        if (null != this.lastEventType) {
            this.lastEventType.release();
        }
        if (null != this.incompleteData) {
            this.incompleteData.release();
        }
    }

    protected static int scanAndFindColon(ByteBuf byteBuf) {
        return byteBuf.forEachByte(SCAN_COLON_PROCESSOR);
    }

    protected static int scanAndFindEndOfLine(ByteBuf byteBuf) {
        return byteBuf.forEachByte(SCAN_EOL_PROCESSOR);
    }

    protected static void skipLineDelimiters(ByteBuf byteBuf) {
        ServerSentEventDecoder.skipTillMatching(byteBuf, SKIP_LINE_DELIMITERS_AND_SPACES_PROCESSOR);
    }

    protected static void skipColonAndWhiteSapaces(ByteBuf byteBuf) {
        ServerSentEventDecoder.skipTillMatching(byteBuf, SKIP_COLON_AND_WHITE_SPACE_PROCESSOR);
    }

    protected static void skipTillMatching(ByteBuf byteBuf, ByteBufProcessor processor) {
        int lastIndexProcessed = byteBuf.forEachByte(processor);
        if (-1 == lastIndexProcessed) {
            byteBuf.readerIndex(byteBuf.readerIndex() + byteBuf.readableBytes());
        } else {
            byteBuf.readerIndex(lastIndexProcessed);
        }
    }

    protected static boolean isLineDelimiter(char c) {
        return c == '\r' || c == '\n';
    }

    static {
        try {
            sseEncodingCharset = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            logger.error("UTF-8 charset not available. Since SSE only contains UTF-8 data, we can not read SSE data.");
            sseEncodingCharset = null;
        }
    }

    private static enum State {
        SkipColonAndWhiteSpaces,
        SkipLineDelimitersAndSpaces,
        ReadFieldName,
        ReadFieldValue;

    }
}

