/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import org.apache.commons.lang3.ArrayUtils;

public class IllegalTokenCheck
extends Check {
    public static final String MSG_KEY = "illegal.token";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{22};
    }

    @Override
    public int[] getAcceptableTokens() {
        return TokenUtils.getAllTokenIds();
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, IllegalTokenCheck.convertToString(ast));
    }

    private static String convertToString(DetailAST ast) {
        String tokenText = ast.getType() == 22 ? ast.getFirstChild().getText() + ast.getText() : ast.getText();
        return tokenText;
    }
}

