/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public final class AnnotationUtility {
    private static final String THE_AST_IS_NULL = "the ast is null";

    private AnnotationUtility() {
        throw new UnsupportedOperationException("do not instantiate.");
    }

    public static boolean containsAnnotation(DetailAST ast, String annotation) {
        if (ast == null) {
            throw new IllegalArgumentException(THE_AST_IS_NULL);
        }
        return AnnotationUtility.getAnnotation(ast, annotation) != null;
    }

    public static boolean containsAnnotation(DetailAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(THE_AST_IS_NULL);
        }
        DetailAST holder = AnnotationUtility.getAnnotationHolder(ast);
        return holder != null && holder.findFirstToken(159) != null;
    }

    public static DetailAST getAnnotationHolder(DetailAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(THE_AST_IS_NULL);
        }
        DetailAST annotationHolder = ast.getType() == 155 || ast.getType() == 16 ? ast.findFirstToken(158) : ast.findFirstToken(5);
        return annotationHolder;
    }

    public static DetailAST getAnnotation(DetailAST ast, String annotation) {
        if (ast == null) {
            throw new IllegalArgumentException(THE_AST_IS_NULL);
        }
        if (annotation == null) {
            throw new IllegalArgumentException("the annotation is null");
        }
        if (CommonUtils.isBlank(annotation)) {
            throw new IllegalArgumentException("the annotation is empty or spaces");
        }
        DetailAST holder = AnnotationUtility.getAnnotationHolder(ast);
        DetailAST result = null;
        for (DetailAST child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST firstChild;
            String name;
            if (child.getType() != 159 || !annotation.equals(name = FullIdent.createFullIdent((firstChild = child.getFirstChild()).getNextSibling()).getText())) continue;
            result = child;
            break;
        }
        return result;
    }
}

