/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.errorhandler;

import com.signalfx.metrics.errorhandler.MetricError;
import com.signalfx.metrics.errorhandler.MetricErrorType;
import com.signalfx.metrics.errorhandler.OnSendErrorHandler;
import com.signalfx.shaded.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingOnSendErrorHandler
implements OnSendErrorHandler {
    private final AtomicInteger totalErrors = new AtomicInteger(0);
    private final Map<MetricErrorType, AtomicInteger> vals = new ConcurrentHashMap<MetricErrorType, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(MetricError metricError) {
        this.totalErrors.incrementAndGet();
        AtomicInteger existingValue = this.vals.get((Object)metricError.getMetricErrorType());
        if (existingValue != null) {
            existingValue.incrementAndGet();
        } else {
            CountingOnSendErrorHandler countingOnSendErrorHandler = this;
            synchronized (countingOnSendErrorHandler) {
                AtomicInteger previousValue = new AtomicInteger(1);
                AtomicInteger prevValue = this.vals.put(metricError.getMetricErrorType(), previousValue);
                if (prevValue != null) {
                    previousValue.addAndGet(prevValue.get());
                }
            }
        }
    }

    public synchronized Map<MetricErrorType, AtomicInteger> getValues() {
        return ImmutableMap.copyOf(this.vals);
    }

    public int getTotalErrorCount() {
        return this.totalErrors.get();
    }
}

