/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.cookie;

import com.signalfx.shaded.apache.http.annotation.Immutable;
import com.signalfx.shaded.apache.http.cookie.Cookie;
import com.signalfx.shaded.apache.http.cookie.CookieAttributeHandler;
import com.signalfx.shaded.apache.http.cookie.CookieOrigin;
import com.signalfx.shaded.apache.http.cookie.CookieRestrictionViolationException;
import com.signalfx.shaded.apache.http.cookie.MalformedCookieException;
import com.signalfx.shaded.apache.http.cookie.SetCookie;
import com.signalfx.shaded.apache.http.util.Args;
import com.signalfx.shaded.apache.http.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setPath(!TextUtils.isBlank(value) ? value : "/");
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (!this.match(cookie, origin)) {
            throw new CookieRestrictionViolationException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + origin.getPath() + "\"");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        boolean match;
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String targetpath = origin.getPath();
        String topmostPath = cookie.getPath();
        if (topmostPath == null) {
            topmostPath = "/";
        }
        if (topmostPath.length() > 1 && topmostPath.endsWith("/")) {
            topmostPath = topmostPath.substring(0, topmostPath.length() - 1);
        }
        if ((match = targetpath.startsWith(topmostPath)) && targetpath.length() != topmostPath.length() && !topmostPath.endsWith("/")) {
            match = targetpath.charAt(topmostPath.length()) == '/';
        }
        return match;
    }
}

