/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.protocol;

import com.signalfx.shaded.apache.http.HttpEntity;
import com.signalfx.shaded.apache.http.HttpEntityEnclosingRequest;
import com.signalfx.shaded.apache.http.HttpException;
import com.signalfx.shaded.apache.http.HttpRequest;
import com.signalfx.shaded.apache.http.HttpRequestInterceptor;
import com.signalfx.shaded.apache.http.HttpVersion;
import com.signalfx.shaded.apache.http.ProtocolException;
import com.signalfx.shaded.apache.http.ProtocolVersion;
import com.signalfx.shaded.apache.http.annotation.Immutable;
import com.signalfx.shaded.apache.http.protocol.HttpContext;
import com.signalfx.shaded.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestContent
implements HttpRequestInterceptor {
    private final boolean overwrite;

    public RequestContent() {
        this(false);
    }

    public RequestContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest) {
            if (this.overwrite) {
                request.removeHeaders("Transfer-Encoding");
                request.removeHeaders("Content-Length");
            } else {
                if (request.containsHeader("Transfer-Encoding")) {
                    throw new ProtocolException("Transfer-encoding header already present");
                }
                if (request.containsHeader("Content-Length")) {
                    throw new ProtocolException("Content-Length header already present");
                }
            }
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity == null) {
                request.addHeader("Content-Length", "0");
                return;
            }
            if (entity.isChunked() || entity.getContentLength() < 0L) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + ver);
                }
                request.addHeader("Transfer-Encoding", "chunked");
            } else {
                request.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !request.containsHeader("Content-Type")) {
                request.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !request.containsHeader("Content-Encoding")) {
                request.addHeader(entity.getContentEncoding());
            }
        }
    }
}

