/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.type;

import com.signalfx.shaded.fasterxml.jackson.databind.JavaType;
import com.signalfx.shaded.fasterxml.jackson.databind.type.TypeFactory;
import com.signalfx.shaded.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public JavaType parse(String string) throws IllegalArgumentException {
        string = string.trim();
        MyTokenizer myTokenizer = new MyTokenizer(string);
        JavaType javaType = this.parseType(myTokenizer);
        if (myTokenizer.hasMoreTokens()) {
            throw this._problem(myTokenizer, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(MyTokenizer myTokenizer) throws IllegalArgumentException {
        if (!myTokenizer.hasMoreTokens()) {
            throw this._problem(myTokenizer, "Unexpected end-of-string");
        }
        Class<?> clazz = this.findClass(myTokenizer.nextToken(), myTokenizer);
        if (myTokenizer.hasMoreTokens()) {
            String string = myTokenizer.nextToken();
            if ("<".equals(string)) {
                return this._factory._fromParameterizedClass(clazz, this.parseTypes(myTokenizer));
            }
            myTokenizer.pushBack(string);
        }
        return this._factory._fromClass(clazz, null);
    }

    protected List<JavaType> parseTypes(MyTokenizer myTokenizer) throws IllegalArgumentException {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (myTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseType(myTokenizer));
            if (!myTokenizer.hasMoreTokens()) break;
            String string = myTokenizer.nextToken();
            if (">".equals(string)) {
                return arrayList;
            }
            if (",".equals(string)) continue;
            throw this._problem(myTokenizer, "Unexpected token '" + string + "', expected ',' or '>')");
        }
        throw this._problem(myTokenizer, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String string, MyTokenizer myTokenizer) {
        try {
            return ClassUtil.findClass(string);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw this._problem(myTokenizer, "Can not locate class '" + string + "', problem: " + exception.getMessage());
        }
    }

    protected IllegalArgumentException _problem(MyTokenizer myTokenizer, String string) {
        return new IllegalArgumentException("Failed to parse type '" + myTokenizer.getAllInput() + "' (remaining: '" + myTokenizer.getRemainingInput() + "'): " + string);
    }

    static final class MyTokenizer
    extends StringTokenizer {
        protected final String _input;
        protected int _index;
        protected String _pushbackToken;

        public MyTokenizer(String string) {
            super(string, "<,>", true);
            this._input = string;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pushbackToken != null || super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            String string;
            if (this._pushbackToken != null) {
                string = this._pushbackToken;
                this._pushbackToken = null;
            } else {
                string = super.nextToken();
            }
            this._index += string.length();
            return string;
        }

        public void pushBack(String string) {
            this._pushbackToken = string;
            this._index -= string.length();
        }

        public String getAllInput() {
            return this._input;
        }

        public String getUsedInput() {
            return this._input.substring(0, this._index);
        }

        public String getRemainingInput() {
            return this._input.substring(this._index);
        }
    }
}

