/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket;

import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.websocket.Extension;
import com.signalfx.shaded.jetty.websocket.WebSocket;
import com.signalfx.shaded.jetty.websocket.WebSocketBuffers;
import com.signalfx.shaded.jetty.websocket.WebSocketConnectionD08;
import com.signalfx.shaded.jetty.websocket.WebSocketFactory;
import com.signalfx.shaded.jetty.websocket.WebSocketServletConnection;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSocketServletConnectionD08
extends WebSocketConnectionD08
implements WebSocketServletConnection {
    private final WebSocketFactory factory;

    public WebSocketServletConnectionD08(WebSocketFactory factory, WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft) throws IOException {
        super(websocket, endpoint, buffers, timestamp, maxIdleTime, protocol, extensions, draft);
        this.factory = factory;
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String subprotocol) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketServletConnectionD08.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        for (Extension ext : this.getExtensions()) {
            response.addHeader("Sec-WebSocket-Extensions", ext.getParameterizedName());
        }
        response.sendError(101);
        this.onFrameHandshake();
        this.onWebSocketOpen();
    }

    @Override
    public void onClose() {
        super.onClose();
        this.factory.removeConnection(this);
    }
}

