/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.junit;

import com.taobao.hsf.junit.Behavior;
import com.taobao.hsf.junit.DefaultBehavior;
import com.taobao.hsf.junit.DelegateTo;
import com.taobao.hsf.junit.ExistingCacheBehavior;
import com.taobao.hsf.junit.Sar;
import com.taobao.hsf.standalone.HSFStarter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.JUnit4;
import org.junit.runners.model.InitializationError;

public class HSFRunner
extends Runner {
    private Runner runner;
    private Behavior behavior;

    public HSFRunner(Class<?> testClass) throws InitializationError {
        try {
            this.behavior = this.prepareClassLoader(testClass);
            this.runner = this.prepareDelegateRunner(testClass, this.behavior);
        }
        catch (NoSuchMethodException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            this.behavior.before();
            this.runner.run(notifier);
        }
        finally {
            this.behavior.after();
        }
    }

    private Runner prepareDelegateRunner(Class<?> clazz, Behavior classLoader) throws Exception {
        Class runnerClass = classLoader.loadClass(JUnit4.class.getName());
        DelegateTo delegateTo = clazz.getAnnotation(DelegateTo.class);
        if (delegateTo != null) {
            runnerClass = classLoader.loadClass(delegateTo.value().getName());
        }
        Class testClassToInvoke = classLoader.loadClass(clazz.getName());
        Constructor constructor = runnerClass.getConstructor(Class.class);
        constructor.setAccessible(true);
        return (Runner)constructor.newInstance(testClassToInvoke);
    }

    private Behavior prepareClassLoader(Class<?> clazz) throws Exception {
        Map<String, Class<?>> cache = HSFRunner.findClassCache();
        boolean share = true;
        Sar sarInfo = clazz.getAnnotation(Sar.class);
        if (sarInfo != null) {
            share = sarInfo.share();
        }
        return cache == null ? new DefaultBehavior(clazz) : (share ? new ExistingCacheBehavior(cache, clazz) : new DefaultBehavior(clazz));
    }

    static Map<String, Class<?>> findClassCache() throws NoSuchFieldException, IllegalAccessException {
        Field exportedClassMapField = HSFStarter.class.getDeclaredField("exportedClassMap");
        exportedClassMapField.setAccessible(true);
        return (Map)exportedClassMapField.get(null);
    }
}

