/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.pandora.toolkit;

import com.taobao.middleware.pandora.toolkit.commons.HttpUtils;
import com.taobao.middleware.pandora.toolkit.commons.StringUtils;
import java.io.File;

public class SarFetcher {
    public static final String SAR_VERSION_PROPERTY_NAME = "sar.version";
    private static final String GET_SAR_VERSION_URL = "http://ops.jm.taobao.org:9999/pandora-web/api/getRecommandSarVersion.do";
    private static final String CHECK_SAR_VERSION_URL = "http://ops.jm.taobao.org:9999/pandora-web/api/getSar.do?version=";
    private static final String DOWNLOAD_SAR_URL_BASE = "http://ops.jm.taobao.org:9999/pandora-web/sar/";
    private static final String SAR_FILE_NAME = "taobao-hsf.tgz";

    public static String getRecommendedSarVersion() {
        return HttpUtils.getRequestResult(GET_SAR_VERSION_URL);
    }

    public static String getSystemSarVersion() {
        return System.getProperty(SAR_VERSION_PROPERTY_NAME);
    }

    public static String getDefaultSarVersion() {
        String sarVersion = SarFetcher.getSystemSarVersion();
        if (StringUtils.isBlank(sarVersion) && StringUtils.isBlank(sarVersion = SarFetcher.getRecommendedSarVersion())) {
            return null;
        }
        return sarVersion;
    }

    public static boolean isSarVersionValid(String sarVersion) {
        String sarJsonStr = HttpUtils.getRequestResult(CHECK_SAR_VERSION_URL + sarVersion);
        return sarJsonStr != null && !sarJsonStr.contains("\"success\":false");
    }

    public static File downloadSar(String sarVersion, String destSarPath) {
        String downloadUrl;
        if (StringUtils.isBlank(sarVersion)) {
            throw new IllegalArgumentException("parameter 'sarVersion' can not be blank.");
        }
        if (StringUtils.isBlank(destSarPath)) {
            throw new IllegalArgumentException("parameter 'destSarPath' can not be blank.");
        }
        File destSarBase = new File(destSarPath);
        if (!destSarBase.exists() || destSarBase.isFile()) {
            throw new IllegalArgumentException("'destSarPath' is not a directory.");
        }
        if (!SarFetcher.isSarVersionValid(sarVersion)) {
            System.err.println("[PandoraToolkit - SarFetcher.downloadSar(String, String)] >> Download taobao-hsf.tgz from pandora-web failed. Invalid sar version: " + sarVersion + ". Please try other sar repository.");
            return null;
        }
        File tgzSarFile = new File(destSarBase, SAR_FILE_NAME);
        if (tgzSarFile.exists()) {
            tgzSarFile.delete();
        }
        if (HttpUtils.downloadFile(downloadUrl = DOWNLOAD_SAR_URL_BASE + sarVersion + "/" + SAR_FILE_NAME, tgzSarFile.getPath())) {
            return tgzSarFile;
        }
        return null;
    }

    public static File downloadSar(String destSarPath) {
        String sarVersion = SarFetcher.getDefaultSarVersion();
        if (sarVersion == null) {
            System.err.println("[PandoraToolkit - SarFetcher.downloadSar(String)] >> Get default sar version failed. Neither '-Dsar.version' nor recommended sar version found.");
            return null;
        }
        return SarFetcher.downloadSar(sarVersion, destSarPath);
    }
}

