/*
 * Decompiled with CFR 0.152.
 */
package test.java;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import main.java.com.UpYun;
import org.junit.Assert;
import org.junit.Test;

public class TestFileBucket {
    private static final String BUCKET_NAME = "sdkfile";
    private static final String OPERATOR_NAME = "tester";
    private static final String OPERATOR_PWD = "grjxv2mxELR3";
    private UpYun upyun = new UpYun("sdkfile", "tester", "grjxv2mxELR3");
    private static final String DIR_ROOT = "/";
    private static final String DIR_MORE = "/1/2/3/";
    private static final String FOLDER_NAME = "tmp";
    private static final String FILE_NAME = "test.txt";
    private static final String SAMPLE_TXT_FILE = System.getProperty("user.dir") + "/test.txt";
    private static final String content = "tmp content";

    @Test
    public void testMkDir() {
        String dir1 = "/tmp";
        boolean result1 = this.upyun.mkDir(dir1);
        Assert.assertTrue((boolean)result1);
        String dir2 = "/1/2/3/tmp";
        boolean result2 = this.upyun.mkDir(dir2, true);
        Assert.assertTrue((boolean)result2);
    }

    @Test
    public void testWriteFile() throws IOException {
        String filePath = "/test.txt";
        String filePath2 = "/1/2/3/test.txt";
        boolean result1 = this.upyun.writeFile(filePath, content);
        Assert.assertTrue((boolean)result1);
        boolean result2 = this.upyun.writeFile(filePath2, content, true);
        Assert.assertTrue((boolean)result2);
        File file = new File(SAMPLE_TXT_FILE);
        boolean result3 = this.upyun.writeFile(filePath, file, true);
        Assert.assertTrue((boolean)result3);
        File file4 = new File(SAMPLE_TXT_FILE);
        this.upyun.setContentMD5(UpYun.md5(file4));
        boolean result4 = this.upyun.writeFile(filePath, file4, true);
        Assert.assertTrue((boolean)result4);
    }

    @Test
    public void testGetFileInfo() {
        String filePath = "/test.txt";
        Map<String, String> result = this.upyun.getFileInfo(filePath);
        Assert.assertTrue((result.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testReadDir() {
        String dirPath = DIR_ROOT;
        List<UpYun.FolderItem> items = this.upyun.readDir(dirPath);
        Assert.assertTrue((items.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBucketUsage() {
        long usage = this.upyun.getBucketUsage();
        Assert.assertTrue((usage > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGetFolderUsage() {
        String dirPath = DIR_ROOT;
        long usage = this.upyun.getFolderUsage(dirPath);
        Assert.assertTrue((usage > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testReadFile() throws IOException {
        String filePath = "/test.txt";
        String datas = this.upyun.readFile(filePath);
        Assert.assertTrue((boolean)content.equals(datas));
        File file = File.createTempFile("upyunTempFile_", "");
        boolean result = this.upyun.readFile(filePath, file);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDeleteFile() {
        String filePath = "/test.txt";
        boolean result = this.upyun.deleteFile(filePath);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testRmDir() {
        String dirPath = "/1/2/3/tmp";
        boolean result = this.upyun.rmDir(dirPath);
        Assert.assertTrue((boolean)result);
    }
}

