/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import java.util.function.Function;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.retry.Retry;

public abstract class ResubscribingEventHandler<T extends InstanceEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Publisher<InstanceEvent> publisher;
    private Disposable subscription;
    private Class<T> eventType;

    protected ResubscribingEventHandler(Publisher<InstanceEvent> publisher, Class<T> eventType) {
        this.publisher = publisher;
        this.eventType = eventType;
    }

    public void start() {
        this.subscription = Flux.from(this.publisher).log(this.log.getName(), Level.FINEST, new SignalType[0]).doOnSubscribe(subscription -> this.log.debug("Subscribed to {} events", this.eventType)).ofType(this.eventType).cast(this.eventType).compose(this::handle).retryWhen((Function)Retry.any().retryMax(Integer.MAX_VALUE).doOnRetry(ctx -> this.log.error("Resubscribing after uncaught error", ctx.exception()))).subscribe();
    }

    protected abstract Publisher<?> handle(Flux<T> var1);

    public void stop() {
        if (this.subscription != null) {
            this.subscription.dispose();
        }
    }
}

