/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.classic;

import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.logback.classic.NDCAdapter;
import java.util.LinkedList;
import java.util.List;

public class SimpleNDCAdapter
implements NDCAdapter {
    private ThreadLocal<List<String>> threadLocalMessagePatterns = new ThreadLocal();
    private ThreadLocal<List<String[]>> threadLocalMessageArguments = new ThreadLocal();

    public void push(String messagePattern, Object ... arguments) {
        MessageFormatter.ArgumentResult argumentResults;
        String[] processedArgs = null;
        if (arguments != null && arguments.length > 0 && (argumentResults = MessageFormatter.evaluateArguments((String)messagePattern, (Object[])arguments)) != null) {
            processedArgs = argumentResults.getArguments();
        }
        List<String> messages = this.threadLocalMessagePatterns.get();
        List<String[]> args = this.threadLocalMessageArguments.get();
        if (messages == null) {
            messages = new LinkedList<String>();
            args = new LinkedList<String[]>();
            this.threadLocalMessagePatterns.set(messages);
            this.threadLocalMessageArguments.set(args);
        }
        messages.add(messagePattern);
        args.add(processedArgs);
    }

    public void pop() {
        List<String> messages = this.threadLocalMessagePatterns.get();
        if (messages == null) {
            return;
        }
        int count = messages.size();
        if (count == 0 || count == 1) {
            this.clear();
            return;
        }
        List<String[]> args = this.threadLocalMessageArguments.get();
        messages.remove(count - 1);
        args.remove(count - 1);
    }

    public int getDepth() {
        List<String> messages = this.threadLocalMessagePatterns.get();
        if (messages == null) {
            return 0;
        }
        int count = messages.size();
        if (count == 0) {
            this.clear();
        }
        return count;
    }

    public void setMaximumDepth(int maximumDepth) {
        int overflow = this.getDepth() - maximumDepth;
        for (int i = 0; i < overflow; ++i) {
            this.pop();
        }
    }

    public boolean isEmpty() {
        return this.getDepth() == 0;
    }

    public void clear() {
        this.threadLocalMessagePatterns.remove();
        this.threadLocalMessageArguments.remove();
    }

    public Message[] getContextStack() {
        List<String> messages = this.threadLocalMessagePatterns.get();
        if (messages == null) {
            return NO_MESSAGES;
        }
        int count = messages.size();
        if (count == 0) {
            this.clear();
            return NO_MESSAGES;
        }
        List<String[]> args = this.threadLocalMessageArguments.get();
        Message[] result = new Message[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new Message(messages.get(i), args.get(i));
        }
        return result;
    }
}

