/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.PrintWriter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.manager.ValueInstrumentListener;
import org.apache.excalibur.instrument.manager.impl.AbstractInstrumentSample;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;

abstract class AbstractValueInstrumentSample
extends AbstractInstrumentSample
implements ValueInstrumentListener {
    protected int m_value = 0;
    protected int m_valueCount;
    protected int m_lastValue;

    protected AbstractValueInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        super(instrumentProxy, name, interval, size, description, lease);
    }

    public final int getInstrumentType() {
        return 2;
    }

    public int getValueInner() {
        return this.m_value;
    }

    protected void advanceToNextSample(boolean reset) {
        if (reset) {
            this.m_lastValue = 0;
        }
        this.m_value = this.m_lastValue;
        this.m_valueCount = 0;
    }

    protected int getFillValue() {
        return this.m_lastValue;
    }

    protected void writeStateAttributes(PrintWriter out) {
        super.writeStateAttributes(out);
        out.print(" value-count=\"");
        out.print(this.m_valueCount);
        out.print("\" last-value=\"");
        out.print(this.m_lastValue);
        out.print("\"");
    }

    protected void loadState(int value, Configuration state) throws ConfigurationException {
        this.m_value = value;
        this.m_valueCount = state.getAttributeAsInteger("value-count");
        this.m_lastValue = state.getAttributeAsInteger("last-value");
    }

    public void setValue(String instrumentName, int value, long time) {
        this.setValueInner(value, time);
    }

    protected abstract void setValueInner(int var1, long var2);
}

