/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus;

import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.FieldsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.library.Architectures;
import com.tngtech.archunit.library.GeneralCodingRules;
import com.tngtech.archunit.library.dependencies.SlicesRuleDefinition;
import io.github.dddplus.annotation.DomainAbility;
import io.github.dddplus.annotation.DomainService;
import io.github.dddplus.annotation.Extension;
import io.github.dddplus.annotation.Partner;
import io.github.dddplus.annotation.Pattern;
import io.github.dddplus.annotation.Specification;
import io.github.dddplus.annotation.Step;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentityResolver;
import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.model.IDomainModelCreator;
import io.github.dddplus.model.IDomainService;
import io.github.dddplus.runtime.BaseDomainAbility;
import io.github.dddplus.specification.ISpecification;
import io.github.dddplus.step.IDomainStep;
import java.lang.annotation.Target;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

public class ArchitectureEnforcer {
    public static final List<ArchRule> requiredRules = new LinkedList<ArchRule>();

    private ArchitectureEnforcer() {
    }

    public static final ArchRule serviceRule() {
        return (ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Service")).should().implement(IDomainService.class).andShould().beAnnotatedWith(DomainService.class).as("Service\u5fc5\u987b\u662fdomain service\uff0c\u4e0d\u80fd\u7528\u4e8e\u5176\u4ed6\u573a\u666f");
    }

    public static final ArchRule partnerDependencyRule() {
        return (ArchRule)((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAPackage("..bp..")).should().dependOnClassesThat().resideInAPackage("..domain..")).as("\u524d\u53f0\u5782\u76f4\u4e1a\u52a1\u5305\u4e0d\u80fd\u4f9d\u8d56domain\u5305\uff0c\u5fc5\u987b\u4f9d\u8d56spec\u5305");
    }

    public static final ArchRule abilityRule() {
        return (ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Ability")).should().beAssignableTo(BaseDomainAbility.class).andShould().beAnnotatedWith(DomainAbility.class).as("ability\u5fc5\u987b\u7ee7\u627fBaseDomainAbility\uff0c\u5e76\u4e14\u52a0@DomainAbility");
    }

    public static final ArchRule specificationRule() {
        return (ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().implement(ISpecification.class)).should().beAnnotatedWith(Specification.class).as("ISpecification rule");
    }

    public static final ArchRule partnerRule() {
        return (ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Partner")).should().beAnnotatedWith(Partner.class).as("Partner\u4f7f\u7528\u89c4\u8303");
    }

    public static final ArchRule noActivityClassAllowed() {
        return (ArchRule)ArchRuleDefinition.noClasses().should().haveNameMatching(".*Activity").as("Activity\u5fc5\u987b\u5b9a\u4e49\u6210Step");
    }

    public static final ArchRule activityRule() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith("Step")).and().haveModifier(JavaModifier.ABSTRACT)).should().implement(IDomainStep.class).as("Activity\u4f7f\u7528\u89c4\u8303");
    }

    public static final ArchRule domainStepRule() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().implement(IDomainStep.class)).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().haveSimpleNameEndingWith("Step").andShould().beAnnotatedWith(Step.class).as("\u9886\u57df\u6b65\u9aa4\u7684\u4f7f\u7528\u89c4\u8303");
    }

    public static final ArchRule patternRule() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Pattern")).and().doNotHaveModifier(JavaModifier.ABSTRACT)).should().beAssignableTo(IIdentityResolver.class).andShould().beAnnotatedWith(Pattern.class).as("Pattern\u7684\u4f7f\u7528\u89c4\u8303");
    }

    public static final ArchRule extensionRule() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areAssignableTo(IDomainExtension.class)).and().areNotInterfaces()).and().haveNameNotMatching(".Default*")).should().haveNameMatching(".*Ext").andShould().beAnnotatedWith(Extension.class).as("\u6269\u5c55\u70b9\u5b9e\u73b0\u7684\u89c4\u8303");
    }

    public static final ArchRule loggers_should_be_private_static_final() {
        return ((FieldsShouldConjunction)ArchRuleDefinition.fields().that().haveRawType(Logger.class).should().bePrivate()).andShould().beStatic().andShould().beFinal().because("by convention");
    }

    public static final ArchRule domainModelRule() {
        return (ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().implement(IDomainModel.class)).should().haveOnlyPrivateConstructors().as("DomainModel\u4e0d\u80fd\u76f4\u63a5new");
    }

    public static final ArchRule creatorRule() {
        return (ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Creator")).should().implement(IDomainModelCreator.class).as("Creator rule");
    }

    public static final ArchRule optionalInterfaceNameStartsWithI() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areInterfaces()).and().areNotAnnotatedWith(Target.class)).and().haveNameNotMatching(".*Dao")).and().haveNameNotMatching(".*Manager")).and().haveNameNotMatching(".*Api")).and().haveNameNotMatching(".*Group")).should().haveSimpleNameStartingWith("I").as("\u63a5\u53e3\u540d\u79f0\u5fc5\u987b\u4ee5I\u5f00\u5934");
    }

    public static final ArchRule controllers_should_only_use_their_own_slice() {
        return SlicesRuleDefinition.slices().matching("..controller.(*)..").namingSlices("Controller $1").as("Controllers").should().notDependOnEachOther();
    }

    public static final ArchRule repositoryRule() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Repository")).and().areNotInterfaces()).should().beAnnotatedWith(Repository.class).as("Repository\u5fc5\u987b\u7528@Repository\u6ce8\u89e3");
    }

    public static final ArchRule aclRule() {
        return (ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(".*Acl")).and().areNotInterfaces()).should().resideInAPackage("..acl..").andShould().beAnnotatedWith(Component.class).as("ACL\u7c7b\u7684\u4f7f\u7528\u89c4\u8303");
    }

    public static final ArchRule optionalDddLayerRule() {
        return Architectures.layeredArchitecture().optionalLayer("Application").definedBy(new String[]{"..app.."}).optionalLayer("Domain").definedBy(new String[]{"..domain.."}).optionalLayer("Infrastructure").definedBy(new String[]{"..infra"}).whereLayer("Application").mayNotBeAccessedByAnyLayer().whereLayer("Domain").mayOnlyBeAccessedByLayers(new String[]{"Application", "Infrastructure"}).whereLayer("Infrastructure").mayOnlyBeAccessedByLayers(new String[]{"Application"}).as("DDD\u5206\u5c42\u67b6\u6784\u89c4\u8303");
    }

    static {
        requiredRules.add(GeneralCodingRules.NO_CLASSES_SHOULD_ACCESS_STANDARD_STREAMS);
        requiredRules.add(GeneralCodingRules.NO_CLASSES_SHOULD_USE_JAVA_UTIL_LOGGING);
        requiredRules.add(ArchitectureEnforcer.loggers_should_be_private_static_final());
        requiredRules.add(ArchitectureEnforcer.repositoryRule());
        requiredRules.add(ArchitectureEnforcer.creatorRule());
        requiredRules.add(ArchitectureEnforcer.partnerDependencyRule());
        requiredRules.add(ArchitectureEnforcer.domainModelRule());
        requiredRules.add(ArchitectureEnforcer.specificationRule());
        requiredRules.add(ArchitectureEnforcer.serviceRule());
        requiredRules.add(ArchitectureEnforcer.noActivityClassAllowed());
        requiredRules.add(ArchitectureEnforcer.activityRule());
        requiredRules.add(ArchitectureEnforcer.aclRule());
        requiredRules.add(ArchitectureEnforcer.patternRule());
        requiredRules.add(ArchitectureEnforcer.abilityRule());
        requiredRules.add(ArchitectureEnforcer.partnerRule());
        requiredRules.add(ArchitectureEnforcer.domainStepRule());
        requiredRules.add(ArchitectureEnforcer.extensionRule());
        requiredRules.add(ArchitectureEnforcer.controllers_should_only_use_their_own_slice());
    }
}

