/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.DomainAbility;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.runtime.BaseDomainAbility;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

class DomainAbilityDef
implements IRegistryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainAbilityDef.class);
    private String domain;
    private String name;
    private BaseDomainAbility domainAbilityBean;
    private Class<? extends BaseDomainAbility> domainAbilityClass;
    private Class<? extends IDomainExtension> extClazz;

    DomainAbilityDef() {
    }

    @Override
    public void registerBean(@NotNull Object bean) {
        DomainAbility domainAbility = InternalAopUtils.getAnnotation(bean, DomainAbility.class);
        this.domain = domainAbility.domain();
        this.name = domainAbility.name();
        if (!(bean instanceof BaseDomainAbility)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST extend BaseDomainAbility");
        }
        this.domainAbilityBean = (BaseDomainAbility)bean;
        this.domainAbilityClass = InternalAopUtils.getTarget(bean).getClass();
        this.resolveExtClazz();
        log.debug("domain ability:{} ext:{}", (Object)bean.getClass().getCanonicalName(), (Object)this.extClazz.getCanonicalName());
        InternalIndexer.index(this);
    }

    private void resolveExtClazz() {
        ResolvableType baseDomainAbilityType = ResolvableType.forClass(this.domainAbilityClass).getSuperType();
        for (int i = 0; i < 5; ++i) {
            for (ResolvableType resolvableType : baseDomainAbilityType.getGenerics()) {
                if (!IDomainExtension.class.isAssignableFrom(resolvableType.resolve())) continue;
                this.extClazz = resolvableType.resolve();
                return;
            }
            baseDomainAbilityType = baseDomainAbilityType.getSuperType();
        }
        throw BootstrapException.ofMessage("Even after 5 tries, still unable to figure out the extension class of BaseDomainAbility:", this.domainAbilityClass.getCanonicalName());
    }

    @Generated
    public String toString() {
        return "DomainAbilityDef(domain=" + this.getDomain() + ", name=" + this.getName() + ", domainAbilityBean=" + this.getDomainAbilityBean() + ", domainAbilityClass=" + this.getDomainAbilityClass() + ", extClazz=" + this.getExtClazz() + ")";
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BaseDomainAbility getDomainAbilityBean() {
        return this.domainAbilityBean;
    }

    @Generated
    public Class<? extends BaseDomainAbility> getDomainAbilityClass() {
        return this.domainAbilityClass;
    }

    @Generated
    public Class<? extends IDomainExtension> getExtClazz() {
        return this.extClazz;
    }
}

