/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.runtime.IStartupListener;
import io.github.dddplus.runtime.registry.RegistryFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
final class DDDBootstrap
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDDBootstrap.class);
    private AtomicBoolean once = new AtomicBoolean();
    @Resource
    private RegistryFactory registryFactory;
    @Autowired(required=false)
    private IStartupListener startupListener;
    private static ApplicationContext applicationContext;

    DDDBootstrap() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!this.once.compareAndSet(false, true)) {
            log.warn("register applicationContext more than once, ignored!");
            return;
        }
        long t0 = System.nanoTime();
        log.info("starting Spring, register DDD beans...");
        this.registryFactory.register(applicationContext);
        log.info("all DDD beans registered, cost {}ms", (Object)((System.nanoTime() - t0) / 1000000L));
        DDDBootstrap.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(applicationContext)) {
            log.info("Spring started complete!");
            if (this.startupListener != null) {
                log.debug("calling IStartupListener: {}", (Object)this.startupListener.getClass().getCanonicalName());
                this.startupListener.onStartComplete();
                log.debug("called IStartupListener: {}", (Object)this.startupListener.getClass().getCanonicalName());
            }
        } else {
            log.info("Spring reloaded complete!");
        }
    }

    static ApplicationContext applicationContext() {
        return applicationContext;
    }
}

