/*
 * Decompiled with CFR 0.152.
 */
package com.linkwechat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="linkwechat.nacos")
public class LinkWechatNacosProperties {
    private String host = "127.0.0.1";
    private Integer port = 8848;
    private String namespace;
    private String username;
    private String password;
    private final String extension = "yaml";
    private final String applicationName = "link-wechat";
    @Autowired
    @JsonIgnore
    private Environment environment;

    @PostConstruct
    public void init() {
        this.overrideFromEnv();
    }

    private void overrideFromEnv() {
        if (StringUtils.isEmpty((Object)this.getHost())) {
            String host = this.environment.resolvePlaceholders("${linkwechat.nacos.host:}");
            if (StringUtils.isEmpty((Object)host)) {
                host = this.environment.resolvePlaceholders("${linkwechat.nacos.host:localhost}");
            }
            this.setHost(host);
        }
        if (this.getPort() == null) {
            this.setPort(Integer.parseInt(this.environment.resolvePlaceholders("${linkwechat.nacos.port:8848}")));
        }
        if (StringUtils.isEmpty((Object)this.getNamespace())) {
            this.setNamespace(this.environment.resolvePlaceholders("${linkwechat.nacos.namespace:}"));
        }
        if (StringUtils.isEmpty((Object)this.getUsername())) {
            this.setUsername(this.environment.resolvePlaceholders("${linkwechat.nacos.username:}"));
        }
        if (StringUtils.isEmpty((Object)this.getPassword())) {
            this.setPassword(this.environment.resolvePlaceholders("${linkwechat.nacos.password:}"));
        }
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkWechatNacosProperties)) {
            return false;
        }
        LinkWechatNacosProperties other = (LinkWechatNacosProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkWechatNacosProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public String toString() {
        return "LinkWechatNacosProperties(host=" + this.getHost() + ", port=" + this.getPort() + ", namespace=" + this.getNamespace() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", extension=" + this.getExtension() + ", applicationName=" + this.getApplicationName() + ", environment=" + this.getEnvironment() + ")";
    }
}

