/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.baichuan.chat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.lnyocly.ai4j.config.BaichuanConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.baichuan.chat.entity.BaichuanChatCompletion;
import io.github.lnyocly.ai4j.platform.baichuan.chat.entity.BaichuanChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaichuanChatService
implements IChatService,
ParameterConvert<BaichuanChatCompletion>,
ResultConvert<BaichuanChatCompletionResponse> {
    private static final Logger log = LoggerFactory.getLogger(BaichuanChatService.class);
    private final BaichuanConfig baichuanConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public BaichuanChatService(Configuration configuration) {
        this.baichuanConfig = configuration.getBaichuanConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.baichuanConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.baichuanConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        chatCompletion.setStreamOptions(null);
        BaichuanChatCompletion baichuanChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (baichuanChatCompletion.getFunctions() != null && !baichuanChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(baichuanChatCompletion.getFunctions());
            baichuanChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            ObjectMapper mapper = new ObjectMapper();
            String requestString = mapper.writeValueAsString((Object)baichuanChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.baichuanConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString)).build();
            Response execute = this.okHttpClient.newCall(request).execute();
            if (!execute.isSuccessful() || execute.body() == null) continue;
            BaichuanChatCompletionResponse baichuanChatCompletionResponse = (BaichuanChatCompletionResponse)mapper.readValue(execute.body().string(), BaichuanChatCompletionResponse.class);
            Choice choice = baichuanChatCompletionResponse.getChoices().get(0);
            finishReason = choice.getFinishReason();
            Usage usage = baichuanChatCompletionResponse.getUsage();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + usage.getCompletionTokens());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + usage.getTotalTokens());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + usage.getPromptTokens());
            if ("tool_calls".equals(finishReason)) {
                ChatMessage message = choice.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(baichuanChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
                }
                baichuanChatCompletion.setMessages(messages);
                continue;
            }
            baichuanChatCompletionResponse.setUsage(allUsage);
            baichuanChatCompletionResponse.setObject("chat.completion");
            chatCompletion.setMessages(baichuanChatCompletion.getMessages());
            chatCompletion.setTools(baichuanChatCompletion.getTools());
            return this.convertChatCompletionResponse(baichuanChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.baichuanConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.baichuanConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        BaichuanChatCompletion baichuanChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (baichuanChatCompletion.getFunctions() != null && !baichuanChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(baichuanChatCompletion.getFunctions());
            baichuanChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)baichuanChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.baichuanConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString)).build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            ChatMessage responseMessage = ChatMessage.withAssistant(eventSourceListener.getToolCalls());
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(baichuanChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                String arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            baichuanChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(baichuanChatCompletion.getMessages());
        chatCompletion.setTools(baichuanChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }

    @Override
    public BaichuanChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        BaichuanChatCompletion baichuanChatCompletion = new BaichuanChatCompletion();
        baichuanChatCompletion.setModel(chatCompletion.getModel());
        baichuanChatCompletion.setMessages(chatCompletion.getMessages());
        baichuanChatCompletion.setStream(chatCompletion.getStream());
        baichuanChatCompletion.setTemperature(Float.valueOf(chatCompletion.getTemperature().floatValue() / 2.0f));
        baichuanChatCompletion.setTopP(chatCompletion.getTopP());
        baichuanChatCompletion.setMaxTokens(chatCompletion.getMaxTokens());
        baichuanChatCompletion.setStop(chatCompletion.getStop());
        baichuanChatCompletion.setTools(chatCompletion.getTools());
        baichuanChatCompletion.setFunctions(chatCompletion.getFunctions());
        baichuanChatCompletion.setToolChoice(chatCompletion.getToolChoice());
        return baichuanChatCompletion;
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                ObjectMapper mapper = new ObjectMapper();
                BaichuanChatCompletionResponse chatCompletionResponse = null;
                String s = null;
                try {
                    chatCompletionResponse = (BaichuanChatCompletionResponse)mapper.readValue(data, BaichuanChatCompletionResponse.class);
                    chatCompletionResponse.setObject("chat.completion.chunk");
                    ChatCompletionResponse response = BaichuanChatService.this.convertChatCompletionResponse(chatCompletionResponse);
                    s = mapper.writeValueAsString((Object)response);
                }
                catch (JsonProcessingException e) {
                    throw new CommonException("Baichuan Chat \u5bf9\u8c61JSON\u5e8f\u5217\u5316\u51fa\u9519");
                }
                eventSourceListener.onEvent(eventSource, id, type, s);
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(BaichuanChatCompletionResponse zhipuChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setId(zhipuChatCompletionResponse.getId());
        chatCompletionResponse.setCreated(zhipuChatCompletionResponse.getCreated());
        chatCompletionResponse.setModel(zhipuChatCompletionResponse.getModel());
        chatCompletionResponse.setChoices(zhipuChatCompletionResponse.getChoices());
        chatCompletionResponse.setUsage(zhipuChatCompletionResponse.getUsage());
        return chatCompletionResponse;
    }
}

