/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.minimax.chat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.lnyocly.ai4j.config.MinimaxConfig;
import io.github.lnyocly.ai4j.convert.chat.ParameterConvert;
import io.github.lnyocly.ai4j.convert.chat.ResultConvert;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.listener.SseListener;
import io.github.lnyocly.ai4j.platform.minimax.chat.entity.MinimaxChatCompletion;
import io.github.lnyocly.ai4j.platform.minimax.chat.entity.MinimaxChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletion;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.tool.Tool;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import io.github.lnyocly.ai4j.service.Configuration;
import io.github.lnyocly.ai4j.service.IChatService;
import io.github.lnyocly.ai4j.utils.ToolUtil;
import io.github.lnyocly.ai4j.utils.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinimaxChatService
implements IChatService,
ParameterConvert<MinimaxChatCompletion>,
ResultConvert<MinimaxChatCompletionResponse> {
    private final MinimaxConfig minimaxConfig;
    private final OkHttpClient okHttpClient;
    private final EventSource.Factory factory;

    public MinimaxChatService(Configuration configuration) {
        this.minimaxConfig = configuration.getMinimaxConfig();
        this.okHttpClient = configuration.getOkHttpClient();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public MinimaxChatCompletion convertChatCompletionObject(ChatCompletion chatCompletion) {
        MinimaxChatCompletion minimaxChatCompletion = new MinimaxChatCompletion();
        minimaxChatCompletion.setModel(chatCompletion.getModel());
        minimaxChatCompletion.setMessages(chatCompletion.getMessages());
        minimaxChatCompletion.setTools(chatCompletion.getTools());
        minimaxChatCompletion.setFunctions(chatCompletion.getFunctions());
        minimaxChatCompletion.setToolChoice(chatCompletion.getToolChoice());
        minimaxChatCompletion.setTemperature(chatCompletion.getTemperature());
        minimaxChatCompletion.setTopP(chatCompletion.getTopP());
        minimaxChatCompletion.setStream(chatCompletion.getStream());
        minimaxChatCompletion.setMaxTokens(chatCompletion.getMaxTokens());
        return minimaxChatCompletion;
    }

    @Override
    public EventSourceListener convertEventSource(final SseListener eventSourceListener) {
        return new EventSourceListener(){

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                if ("[DONE]".equalsIgnoreCase(data)) {
                    eventSourceListener.onEvent(eventSource, id, type, data);
                    return;
                }
                ObjectMapper mapper = new ObjectMapper();
                MinimaxChatCompletionResponse chatCompletionResponse = null;
                String s = null;
                try {
                    chatCompletionResponse = (MinimaxChatCompletionResponse)mapper.readValue(data, MinimaxChatCompletionResponse.class);
                    ChatCompletionResponse response = MinimaxChatService.this.convertChatCompletionResponse(chatCompletionResponse);
                    s = mapper.writeValueAsString((Object)response);
                }
                catch (JsonProcessingException e) {
                    throw new CommonException("Minimax Chat \u5bf9\u8c61JSON\u5e8f\u5217\u5316\u51fa\u9519");
                }
                eventSourceListener.onEvent(eventSource, id, type, s);
            }

            public void onClosed(@NotNull EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }
        };
    }

    @Override
    public ChatCompletionResponse convertChatCompletionResponse(MinimaxChatCompletionResponse minimaxChatCompletionResponse) {
        ChatCompletionResponse chatCompletionResponse = new ChatCompletionResponse();
        chatCompletionResponse.setId(minimaxChatCompletionResponse.getId());
        chatCompletionResponse.setObject(minimaxChatCompletionResponse.getObject());
        chatCompletionResponse.setCreated(minimaxChatCompletionResponse.getCreated());
        chatCompletionResponse.setModel(minimaxChatCompletionResponse.getModel());
        chatCompletionResponse.setChoices(minimaxChatCompletionResponse.getChoices());
        chatCompletionResponse.setUsage(minimaxChatCompletionResponse.getUsage());
        return chatCompletionResponse;
    }

    @Override
    public ChatCompletionResponse chatCompletion(String baseUrl, String apiKey, ChatCompletion chatCompletion) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.minimaxConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.minimaxConfig.getApiKey();
        }
        chatCompletion.setStream(false);
        chatCompletion.setStreamOptions(null);
        MinimaxChatCompletion minimaxChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (minimaxChatCompletion.getFunctions() != null && !minimaxChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(minimaxChatCompletion.getFunctions());
            minimaxChatCompletion.setTools(tools);
        }
        Usage allUsage = new Usage();
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            ObjectMapper mapper = new ObjectMapper();
            String requestString = mapper.writeValueAsString((Object)minimaxChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.minimaxConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestString)).build();
            Response execute = this.okHttpClient.newCall(request).execute();
            if (!execute.isSuccessful() || execute.body() == null) continue;
            MinimaxChatCompletionResponse minimaxChatCompletionResponse = (MinimaxChatCompletionResponse)mapper.readValue(execute.body().string(), MinimaxChatCompletionResponse.class);
            Choice choice = minimaxChatCompletionResponse.getChoices().get(0);
            finishReason = choice.getFinishReason();
            Usage usage = minimaxChatCompletionResponse.getUsage();
            allUsage.setCompletionTokens(allUsage.getCompletionTokens() + usage.getCompletionTokens());
            allUsage.setTotalTokens(allUsage.getTotalTokens() + usage.getTotalTokens());
            allUsage.setPromptTokens(allUsage.getPromptTokens() + usage.getPromptTokens());
            if ("tool_calls".equals(finishReason)) {
                ChatMessage message = choice.getMessage();
                List<ToolCall> toolCalls = message.getToolCalls();
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(minimaxChatCompletion.getMessages());
                messages.add(message);
                for (ToolCall toolCall : toolCalls) {
                    String functionName = toolCall.getFunction().getName();
                    String arguments = toolCall.getFunction().getArguments();
                    String functionResponse = ToolUtil.invoke(functionName, arguments);
                    messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
                }
                minimaxChatCompletion.setMessages(messages);
                continue;
            }
            minimaxChatCompletionResponse.setUsage(allUsage);
            chatCompletion.setMessages(minimaxChatCompletion.getMessages());
            chatCompletion.setTools(minimaxChatCompletion.getTools());
            return this.convertChatCompletionResponse(minimaxChatCompletionResponse);
        }
        return null;
    }

    @Override
    public ChatCompletionResponse chatCompletion(ChatCompletion chatCompletion) throws Exception {
        return this.chatCompletion(null, null, chatCompletion);
    }

    @Override
    public void chatCompletionStream(String baseUrl, String apiKey, ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        if (baseUrl == null || "".equals(baseUrl)) {
            baseUrl = this.minimaxConfig.getApiHost();
        }
        if (apiKey == null || "".equals(apiKey)) {
            apiKey = this.minimaxConfig.getApiKey();
        }
        chatCompletion.setStream(true);
        MinimaxChatCompletion minimaxChatCompletion = this.convertChatCompletionObject(chatCompletion);
        if (minimaxChatCompletion.getFunctions() != null && !minimaxChatCompletion.getFunctions().isEmpty()) {
            List<Tool> tools = ToolUtil.getAllFunctionTools(minimaxChatCompletion.getFunctions());
            minimaxChatCompletion.setTools(tools);
        }
        String finishReason = "first";
        while ("first".equals(finishReason) || "tool_calls".equals(finishReason)) {
            finishReason = null;
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)minimaxChatCompletion);
            Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(ValidateUtil.concatUrl(baseUrl, this.minimaxConfig.getChatCompletionUrl())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString)).build();
            this.factory.newEventSource(request, this.convertEventSource(eventSourceListener));
            eventSourceListener.getCountDownLatch().await();
            finishReason = eventSourceListener.getFinishReason();
            List<ToolCall> toolCalls = eventSourceListener.getToolCalls();
            if (!"tool_calls".equals(finishReason) || toolCalls.isEmpty()) continue;
            ChatMessage responseMessage = ChatMessage.withAssistant(eventSourceListener.getToolCalls());
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(minimaxChatCompletion.getMessages());
            messages.add(responseMessage);
            for (ToolCall toolCall : toolCalls) {
                String functionName = toolCall.getFunction().getName();
                String arguments = toolCall.getFunction().getArguments();
                String functionResponse = ToolUtil.invoke(functionName, arguments);
                messages.add(ChatMessage.withTool(functionResponse, toolCall.getId()));
            }
            eventSourceListener.setToolCalls(new ArrayList<ToolCall>());
            eventSourceListener.setToolCall(null);
            minimaxChatCompletion.setMessages(messages);
        }
        chatCompletion.setMessages(minimaxChatCompletion.getMessages());
        chatCompletion.setTools(minimaxChatCompletion.getTools());
    }

    @Override
    public void chatCompletionStream(ChatCompletion chatCompletion, SseListener eventSourceListener) throws Exception {
        this.chatCompletionStream(null, null, chatCompletion, eventSourceListener);
    }
}

